/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Individual regular expression match result of finding a target regex in a longer text string")
@JsonPropertyOrder(value={"CharacterOffsetStart", "CharacterOffsetEnd", "ContainingLine", "MatchValue", "MatchGroups"})
@JsonTypeName(value="FindRegexMatch")
public class FindRegexMatch {
    public static final String JSON_PROPERTY_CHARACTER_OFFSET_START = "CharacterOffsetStart";
    private Integer characterOffsetStart;
    public static final String JSON_PROPERTY_CHARACTER_OFFSET_END = "CharacterOffsetEnd";
    private Integer characterOffsetEnd;
    public static final String JSON_PROPERTY_CONTAINING_LINE = "ContainingLine";
    private String containingLine;
    public static final String JSON_PROPERTY_MATCH_VALUE = "MatchValue";
    private String matchValue;
    public static final String JSON_PROPERTY_MATCH_GROUPS = "MatchGroups";
    private List<String> matchGroups = null;

    public FindRegexMatch characterOffsetStart(Integer characterOffsetStart) {
        this.characterOffsetStart = characterOffsetStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the start of the match")
    @JsonProperty(value="CharacterOffsetStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCharacterOffsetStart() {
        return this.characterOffsetStart;
    }

    public void setCharacterOffsetStart(Integer characterOffsetStart) {
        this.characterOffsetStart = characterOffsetStart;
    }

    public FindRegexMatch characterOffsetEnd(Integer characterOffsetEnd) {
        this.characterOffsetEnd = characterOffsetEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the end of the match")
    @JsonProperty(value="CharacterOffsetEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCharacterOffsetEnd() {
        return this.characterOffsetEnd;
    }

    public void setCharacterOffsetEnd(Integer characterOffsetEnd) {
        this.characterOffsetEnd = characterOffsetEnd;
    }

    public FindRegexMatch containingLine(String containingLine) {
        this.containingLine = containingLine;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text content of the line containing the match")
    @JsonProperty(value="ContainingLine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainingLine() {
        return this.containingLine;
    }

    public void setContainingLine(String containingLine) {
        this.containingLine = containingLine;
    }

    public FindRegexMatch matchValue(String matchValue) {
        this.matchValue = matchValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The match value")
    @JsonProperty(value="MatchValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(String matchValue) {
        this.matchValue = matchValue;
    }

    public FindRegexMatch matchGroups(List<String> matchGroups) {
        this.matchGroups = matchGroups;
        return this;
    }

    public FindRegexMatch addMatchGroupsItem(String matchGroupsItem) {
        if (this.matchGroups == null) {
            this.matchGroups = new ArrayList<String>();
        }
        this.matchGroups.add(matchGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Regular expression regex match groups; these correspond to the match values")
    @JsonProperty(value="MatchGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMatchGroups() {
        return this.matchGroups;
    }

    public void setMatchGroups(List<String> matchGroups) {
        this.matchGroups = matchGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindRegexMatch findRegexMatch = (FindRegexMatch)o;
        return Objects.equals(this.characterOffsetStart, findRegexMatch.characterOffsetStart) && Objects.equals(this.characterOffsetEnd, findRegexMatch.characterOffsetEnd) && Objects.equals(this.containingLine, findRegexMatch.containingLine) && Objects.equals(this.matchValue, findRegexMatch.matchValue) && Objects.equals(this.matchGroups, findRegexMatch.matchGroups);
    }

    public int hashCode() {
        return Objects.hash(this.characterOffsetStart, this.characterOffsetEnd, this.containingLine, this.matchValue, this.matchGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindRegexMatch {\n");
        sb.append("    characterOffsetStart: ").append(this.toIndentedString(this.characterOffsetStart)).append("\n");
        sb.append("    characterOffsetEnd: ").append(this.toIndentedString(this.characterOffsetEnd)).append("\n");
        sb.append("    containingLine: ").append(this.toIndentedString(this.containingLine)).append("\n");
        sb.append("    matchValue: ").append(this.toIndentedString(this.matchValue)).append("\n");
        sb.append("    matchGroups: ").append(this.toIndentedString(this.matchGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

