/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Location of one face in an image, along with match results")
@JsonPropertyOrder(value={"LeftX", "TopY", "RightX", "BottomY", "HighConfidenceMatch", "MatchScore"})
@JsonTypeName(value="FaceMatch")
public class FaceMatch {
    public static final String JSON_PROPERTY_LEFT_X = "LeftX";
    private Integer leftX;
    public static final String JSON_PROPERTY_TOP_Y = "TopY";
    private Integer topY;
    public static final String JSON_PROPERTY_RIGHT_X = "RightX";
    private Integer rightX;
    public static final String JSON_PROPERTY_BOTTOM_Y = "BottomY";
    private Integer bottomY;
    public static final String JSON_PROPERTY_HIGH_CONFIDENCE_MATCH = "HighConfidenceMatch";
    private Boolean highConfidenceMatch;
    public static final String JSON_PROPERTY_MATCH_SCORE = "MatchScore";
    private Double matchScore;

    public FaceMatch leftX(Integer leftX) {
        this.leftX = leftX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the left side of the face")
    @JsonProperty(value="LeftX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeftX() {
        return this.leftX;
    }

    public void setLeftX(Integer leftX) {
        this.leftX = leftX;
    }

    public FaceMatch topY(Integer topY) {
        this.topY = topY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the top side of the face")
    @JsonProperty(value="TopY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTopY() {
        return this.topY;
    }

    public void setTopY(Integer topY) {
        this.topY = topY;
    }

    public FaceMatch rightX(Integer rightX) {
        this.rightX = rightX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X coordinate of the right side of the face")
    @JsonProperty(value="RightX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRightX() {
        return this.rightX;
    }

    public void setRightX(Integer rightX) {
        this.rightX = rightX;
    }

    public FaceMatch bottomY(Integer bottomY) {
        this.bottomY = bottomY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y coordinate of the bottom side of the face")
    @JsonProperty(value="BottomY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(Integer bottomY) {
        this.bottomY = bottomY;
    }

    public FaceMatch highConfidenceMatch(Boolean highConfidenceMatch) {
        this.highConfidenceMatch = highConfidenceMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if there is a high confidence match, false otherwise")
    @JsonProperty(value="HighConfidenceMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHighConfidenceMatch() {
        return this.highConfidenceMatch;
    }

    public void setHighConfidenceMatch(Boolean highConfidenceMatch) {
        this.highConfidenceMatch = highConfidenceMatch;
    }

    public FaceMatch matchScore(Double matchScore) {
        this.matchScore = matchScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match score from 0.0 to 1.0 with higher scores indicating a greater match; scores above 0.7 indicate a match")
    @JsonProperty(value="MatchScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMatchScore() {
        return this.matchScore;
    }

    public void setMatchScore(Double matchScore) {
        this.matchScore = matchScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceMatch faceMatch = (FaceMatch)o;
        return Objects.equals(this.leftX, faceMatch.leftX) && Objects.equals(this.topY, faceMatch.topY) && Objects.equals(this.rightX, faceMatch.rightX) && Objects.equals(this.bottomY, faceMatch.bottomY) && Objects.equals(this.highConfidenceMatch, faceMatch.highConfidenceMatch) && Objects.equals(this.matchScore, faceMatch.matchScore);
    }

    public int hashCode() {
        return Objects.hash(this.leftX, this.topY, this.rightX, this.bottomY, this.highConfidenceMatch, this.matchScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaceMatch {\n");
        sb.append("    leftX: ").append(this.toIndentedString(this.leftX)).append("\n");
        sb.append("    topY: ").append(this.toIndentedString(this.topY)).append("\n");
        sb.append("    rightX: ").append(this.toIndentedString(this.rightX)).append("\n");
        sb.append("    bottomY: ").append(this.toIndentedString(this.bottomY)).append("\n");
        sb.append("    highConfidenceMatch: ").append(this.toIndentedString(this.highConfidenceMatch)).append("\n");
        sb.append("    matchScore: ").append(this.toIndentedString(this.matchScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

