/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.FaceWithLandmarks;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Results of locating faces in an image")
@JsonPropertyOrder(value={"Successful", "Faces", "FaceCount", "ErrorDetails"})
@JsonTypeName(value="FaceLocateWithLandmarksResponse")
public class FaceLocateWithLandmarksResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_FACES = "Faces";
    private List<FaceWithLandmarks> faces = null;
    public static final String JSON_PROPERTY_FACE_COUNT = "FaceCount";
    private Integer faceCount;
    public static final String JSON_PROPERTY_ERROR_DETAILS = "ErrorDetails";
    private String errorDetails;

    public FaceLocateWithLandmarksResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public FaceLocateWithLandmarksResponse faces(List<FaceWithLandmarks> faces) {
        this.faces = faces;
        return this;
    }

    public FaceLocateWithLandmarksResponse addFacesItem(FaceWithLandmarks facesItem) {
        if (this.faces == null) {
            this.faces = new ArrayList<FaceWithLandmarks>();
        }
        this.faces.add(facesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of faces found in the image")
    @JsonProperty(value="Faces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FaceWithLandmarks> getFaces() {
        return this.faces;
    }

    public void setFaces(List<FaceWithLandmarks> faces) {
        this.faces = faces;
    }

    public FaceLocateWithLandmarksResponse faceCount(Integer faceCount) {
        this.faceCount = faceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of faces found in the image")
    @JsonProperty(value="FaceCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFaceCount() {
        return this.faceCount;
    }

    public void setFaceCount(Integer faceCount) {
        this.faceCount = faceCount;
    }

    public FaceLocateWithLandmarksResponse errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details of any errors that occurred")
    @JsonProperty(value="ErrorDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceLocateWithLandmarksResponse faceLocateWithLandmarksResponse = (FaceLocateWithLandmarksResponse)o;
        return Objects.equals(this.successful, faceLocateWithLandmarksResponse.successful) && Objects.equals(this.faces, faceLocateWithLandmarksResponse.faces) && Objects.equals(this.faceCount, faceLocateWithLandmarksResponse.faceCount) && Objects.equals(this.errorDetails, faceLocateWithLandmarksResponse.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.faces, this.faceCount, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaceLocateWithLandmarksResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    faces: ").append(this.toIndentedString(this.faces)).append("\n");
        sb.append("    faceCount: ").append(this.toIndentedString(this.faceCount)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

