/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EXIF tag and value")
@JsonPropertyOrder(value={"Tag", "DataType", "DataValue"})
@JsonTypeName(value="ExifValue")
public class ExifValue {
    public static final String JSON_PROPERTY_TAG = "Tag";
    private String tag;
    public static final String JSON_PROPERTY_DATA_TYPE = "DataType";
    private String dataType;
    public static final String JSON_PROPERTY_DATA_VALUE = "DataValue";
    private String dataValue;

    public ExifValue tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tag name for the EXIF value")
    @JsonProperty(value="Tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ExifValue dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date type of the EXIF value")
    @JsonProperty(value="DataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public ExifValue dataValue(String dataValue) {
        this.dataValue = dataValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value, formatted as a string of the EXIF value")
    @JsonProperty(value="DataValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(String dataValue) {
        this.dataValue = dataValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExifValue exifValue = (ExifValue)o;
        return Objects.equals(this.tag, exifValue.tag) && Objects.equals(this.dataType, exifValue.dataType) && Objects.equals(this.dataValue, exifValue.dataValue);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.dataType, this.dataValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExifValue {\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    dataValue: ").append(this.toIndentedString(this.dataValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

