/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An EML file attachment")
@JsonPropertyOrder(value={"Name", "Content"})
@JsonTypeName(value="EmlAttachment")
public class EmlAttachment {
    public static final String JSON_PROPERTY_NAME = "Name";
    private String name;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private byte[] content;

    public EmlAttachment name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the attachment, including file extension")
    @JsonProperty(value="Name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmlAttachment content(byte[] content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The EML attachment as a byte[]")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmlAttachment emlAttachment = (EmlAttachment)o;
        return Objects.equals(this.name, emlAttachment.name) && Arrays.equals(this.content, emlAttachment.content);
    }

    public int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.content));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmlAttachment {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

