/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DrawTextInstance;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to draw one or more pieces of text onto an image")
@JsonPropertyOrder(value={"BaseImageBytes", "BaseImageUrl", "TextToDraw"})
@JsonTypeName(value="DrawTextRequest")
public class DrawTextRequest {
    public static final String JSON_PROPERTY_BASE_IMAGE_BYTES = "BaseImageBytes";
    private byte[] baseImageBytes;
    public static final String JSON_PROPERTY_BASE_IMAGE_URL = "BaseImageUrl";
    private String baseImageUrl;
    public static final String JSON_PROPERTY_TEXT_TO_DRAW = "TextToDraw";
    private List<DrawTextInstance> textToDraw = null;

    public DrawTextRequest baseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw text on, in bytes.  You can also use the BaseImageUrl instead to supply image input as a URL")
    @JsonProperty(value="BaseImageBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getBaseImageBytes() {
        return this.baseImageBytes;
    }

    public void setBaseImageBytes(byte[] baseImageBytes) {
        this.baseImageBytes = baseImageBytes;
    }

    public DrawTextRequest baseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image to draw text on, as an HTTP or HTTPS fully-qualified URL")
    @JsonProperty(value="BaseImageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseImageUrl() {
        return this.baseImageUrl;
    }

    public void setBaseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
    }

    public DrawTextRequest textToDraw(List<DrawTextInstance> textToDraw) {
        this.textToDraw = textToDraw;
        return this;
    }

    public DrawTextRequest addTextToDrawItem(DrawTextInstance textToDrawItem) {
        if (this.textToDraw == null) {
            this.textToDraw = new ArrayList<DrawTextInstance>();
        }
        this.textToDraw.add(textToDrawItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="One or more pieces of text to draw onto the image")
    @JsonProperty(value="TextToDraw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DrawTextInstance> getTextToDraw() {
        return this.textToDraw;
    }

    public void setTextToDraw(List<DrawTextInstance> textToDraw) {
        this.textToDraw = textToDraw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawTextRequest drawTextRequest = (DrawTextRequest)o;
        return Arrays.equals(this.baseImageBytes, drawTextRequest.baseImageBytes) && Objects.equals(this.baseImageUrl, drawTextRequest.baseImageUrl) && Objects.equals(this.textToDraw, drawTextRequest.textToDraw);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.baseImageBytes), this.baseImageUrl, this.textToDraw);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawTextRequest {\n");
        sb.append("    baseImageBytes: ").append(this.toIndentedString(this.baseImageBytes)).append("\n");
        sb.append("    baseImageUrl: ").append(this.toIndentedString(this.baseImageUrl)).append("\n");
        sb.append("    textToDraw: ").append(this.toIndentedString(this.textToDraw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

