/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Text instance to draw on an image")
@JsonPropertyOrder(value={"Text", "FontFamilyName", "FontSize", "Color", "X", "Y", "Width", "Height"})
@JsonTypeName(value="DrawTextInstance")
public class DrawTextInstance {
    public static final String JSON_PROPERTY_TEXT = "Text";
    private String text;
    public static final String JSON_PROPERTY_FONT_FAMILY_NAME = "FontFamilyName";
    private String fontFamilyName;
    public static final String JSON_PROPERTY_FONT_SIZE = "FontSize";
    private Double fontSize;
    public static final String JSON_PROPERTY_COLOR = "Color";
    private String color;
    public static final String JSON_PROPERTY_X = "X";
    private Double X;
    public static final String JSON_PROPERTY_Y = "Y";
    private Double Y;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Double width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Double height;

    public DrawTextInstance text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text string to draw")
    @JsonProperty(value="Text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public DrawTextInstance fontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font Family to use.  Leave blank to default to \"Arial\".  Supported fonts including Arial, Calibri, Cambria, Candara, Consolas, Constantia, Corbel, Courier New, Courier Regular, Georgia, Impact Regular, Lucida, Modern Regular, Tahoma, Times New Roman, Verdana")
    @JsonProperty(value="FontFamilyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public DrawTextInstance fontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font size to use.")
    @JsonProperty(value="FontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public DrawTextInstance color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color to use - can be a hex value (with #) or HTML common color name")
    @JsonProperty(value="Color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public DrawTextInstance X(Double X) {
        this.X = X;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pixel location of the left edge of the text location")
    @JsonProperty(value="X")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getX() {
        return this.X;
    }

    public void setX(Double X) {
        this.X = X;
    }

    public DrawTextInstance Y(Double Y) {
        this.Y = Y;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pixel location of the top edge of the text location")
    @JsonProperty(value="Y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getY() {
        return this.Y;
    }

    public void setY(Double Y) {
        this.Y = Y;
    }

    public DrawTextInstance width(Double width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the text box to draw the text in; text will wrap inside this box")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public DrawTextInstance height(Double height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height in pixels of the text box to draw the text in; text will wrap inside this box")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawTextInstance drawTextInstance = (DrawTextInstance)o;
        return Objects.equals(this.text, drawTextInstance.text) && Objects.equals(this.fontFamilyName, drawTextInstance.fontFamilyName) && Objects.equals(this.fontSize, drawTextInstance.fontSize) && Objects.equals(this.color, drawTextInstance.color) && Objects.equals(this.X, drawTextInstance.X) && Objects.equals(this.Y, drawTextInstance.Y) && Objects.equals(this.width, drawTextInstance.width) && Objects.equals(this.height, drawTextInstance.height);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.fontFamilyName, this.fontSize, this.color, this.X, this.Y, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawTextInstance {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    fontFamilyName: ").append(this.toIndentedString(this.fontFamilyName)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    X: ").append(this.toIndentedString(this.X)).append("\n");
        sb.append("    Y: ").append(this.toIndentedString(this.Y)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

