/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Rectangle instance to draw on an image")
@JsonPropertyOrder(value={"BorderColor", "BorderWidth", "FillColor", "X", "Y", "Width", "Height"})
@JsonTypeName(value="DrawRectangleInstance")
public class DrawRectangleInstance {
    public static final String JSON_PROPERTY_BORDER_COLOR = "BorderColor";
    private String borderColor;
    public static final String JSON_PROPERTY_BORDER_WIDTH = "BorderWidth";
    private Double borderWidth;
    public static final String JSON_PROPERTY_FILL_COLOR = "FillColor";
    private String fillColor;
    public static final String JSON_PROPERTY_X = "X";
    private Double X;
    public static final String JSON_PROPERTY_Y = "Y";
    private Double Y;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Double width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Double height;

    public DrawRectangleInstance borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Border Color to use - can be a hex value (with #) or HTML common color name.  Transparent colors are supported.")
    @JsonProperty(value="BorderColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public DrawRectangleInstance borderWidth(Double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the border.  Pass in 0 to draw a rectangle with no border")
    @JsonProperty(value="BorderWidth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Double borderWidth) {
        this.borderWidth = borderWidth;
    }

    public DrawRectangleInstance fillColor(String fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fill Color to use - can be a hex value (with #) or HTML common color name.  Transparent colors are supported.  Leave blank to not fill the rectangle.")
    @JsonProperty(value="FillColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public DrawRectangleInstance X(Double X) {
        this.X = X;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pixel location of the left edge of the rectangle location")
    @JsonProperty(value="X")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getX() {
        return this.X;
    }

    public void setX(Double X) {
        this.X = X;
    }

    public DrawRectangleInstance Y(Double Y) {
        this.Y = Y;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pixel location of the top edge of the rectangle location")
    @JsonProperty(value="Y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getY() {
        return this.Y;
    }

    public void setY(Double Y) {
        this.Y = Y;
    }

    public DrawRectangleInstance width(Double width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width in pixels of the rectangle")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public DrawRectangleInstance height(Double height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height in pixels of the rectangle")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawRectangleInstance drawRectangleInstance = (DrawRectangleInstance)o;
        return Objects.equals(this.borderColor, drawRectangleInstance.borderColor) && Objects.equals(this.borderWidth, drawRectangleInstance.borderWidth) && Objects.equals(this.fillColor, drawRectangleInstance.fillColor) && Objects.equals(this.X, drawRectangleInstance.X) && Objects.equals(this.Y, drawRectangleInstance.Y) && Objects.equals(this.width, drawRectangleInstance.width) && Objects.equals(this.height, drawRectangleInstance.height);
    }

    public int hashCode() {
        return Objects.hash(this.borderColor, this.borderWidth, this.fillColor, this.X, this.Y, this.width, this.height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawRectangleInstance {\n");
        sb.append("    borderColor: ").append(this.toIndentedString(this.borderColor)).append("\n");
        sb.append("    borderWidth: ").append(this.toIndentedString(this.borderWidth)).append("\n");
        sb.append("    fillColor: ").append(this.toIndentedString(this.fillColor)).append("\n");
        sb.append("    X: ").append(this.toIndentedString(this.X)).append("\n");
        sb.append("    Y: ").append(this.toIndentedString(this.Y)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

