/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ColorResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a get dominant color operation")
@JsonPropertyOrder(value={"Successful", "DominantColors"})
@JsonTypeName(value="DominantColorResult")
public class DominantColorResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_DOMINANT_COLORS = "DominantColors";
    private List<ColorResult> dominantColors = null;

    public DominantColorResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public DominantColorResult dominantColors(List<ColorResult> dominantColors) {
        this.dominantColors = dominantColors;
        return this;
    }

    public DominantColorResult addDominantColorsItem(ColorResult dominantColorsItem) {
        if (this.dominantColors == null) {
            this.dominantColors = new ArrayList<ColorResult>();
        }
        this.dominantColors.add(dominantColorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dominant colors in the image, in order where most dominant color is in the first index position (0), the second most-dominant color is in index position 1 and so on")
    @JsonProperty(value="DominantColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ColorResult> getDominantColors() {
        return this.dominantColors;
    }

    public void setDominantColors(List<ColorResult> dominantColors) {
        this.dominantColors = dominantColors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DominantColorResult dominantColorResult = (DominantColorResult)o;
        return Objects.equals(this.successful, dominantColorResult.successful) && Objects.equals(this.dominantColors, dominantColorResult.dominantColors);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.dominantColors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DominantColorResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    dominantColors: ").append(this.toIndentedString(this.dominantColors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

