/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxComment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Top-level Comment in a Word Document")
@JsonPropertyOrder(value={"Path", "Author", "AuthorInitials", "CommentText", "CommentDate", "ReplyChildComments", "Done"})
@JsonTypeName(value="DocxTopLevelComment")
public class DocxTopLevelComment {
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_AUTHOR = "Author";
    private String author;
    public static final String JSON_PROPERTY_AUTHOR_INITIALS = "AuthorInitials";
    private String authorInitials;
    public static final String JSON_PROPERTY_COMMENT_TEXT = "CommentText";
    private String commentText;
    public static final String JSON_PROPERTY_COMMENT_DATE = "CommentDate";
    private OffsetDateTime commentDate;
    public static final String JSON_PROPERTY_REPLY_CHILD_COMMENTS = "ReplyChildComments";
    private List<DocxComment> replyChildComments = null;
    public static final String JSON_PROPERTY_DONE = "Done";
    private Boolean done;

    public DocxTopLevelComment path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the comment in the document")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxTopLevelComment author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Author name of the comment")
    @JsonProperty(value="Author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public DocxTopLevelComment authorInitials(String authorInitials) {
        this.authorInitials = authorInitials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initials of the author of the comment")
    @JsonProperty(value="AuthorInitials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorInitials() {
        return this.authorInitials;
    }

    public void setAuthorInitials(String authorInitials) {
        this.authorInitials = authorInitials;
    }

    public DocxTopLevelComment commentText(String commentText) {
        this.commentText = commentText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text content of the comment")
    @JsonProperty(value="CommentText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public DocxTopLevelComment commentDate(OffsetDateTime commentDate) {
        this.commentDate = commentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date timestamp of the comment")
    @JsonProperty(value="CommentDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCommentDate() {
        return this.commentDate;
    }

    public void setCommentDate(OffsetDateTime commentDate) {
        this.commentDate = commentDate;
    }

    public DocxTopLevelComment replyChildComments(List<DocxComment> replyChildComments) {
        this.replyChildComments = replyChildComments;
        return this;
    }

    public DocxTopLevelComment addReplyChildCommentsItem(DocxComment replyChildCommentsItem) {
        if (this.replyChildComments == null) {
            this.replyChildComments = new ArrayList<DocxComment>();
        }
        this.replyChildComments.add(replyChildCommentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Child comments, that are replies to this one")
    @JsonProperty(value="ReplyChildComments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxComment> getReplyChildComments() {
        return this.replyChildComments;
    }

    public void setReplyChildComments(List<DocxComment> replyChildComments) {
        this.replyChildComments = replyChildComments;
    }

    public DocxTopLevelComment done(Boolean done) {
        this.done = done;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this comment is marked as Done in Word, otherwise it is false")
    @JsonProperty(value="Done")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDone() {
        return this.done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxTopLevelComment docxTopLevelComment = (DocxTopLevelComment)o;
        return Objects.equals(this.path, docxTopLevelComment.path) && Objects.equals(this.author, docxTopLevelComment.author) && Objects.equals(this.authorInitials, docxTopLevelComment.authorInitials) && Objects.equals(this.commentText, docxTopLevelComment.commentText) && Objects.equals(this.commentDate, docxTopLevelComment.commentDate) && Objects.equals(this.replyChildComments, docxTopLevelComment.replyChildComments) && Objects.equals(this.done, docxTopLevelComment.done);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.author, this.authorInitials, this.commentText, this.commentDate, this.replyChildComments, this.done);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxTopLevelComment {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    authorInitials: ").append(this.toIndentedString(this.authorInitials)).append("\n");
        sb.append("    commentText: ").append(this.toIndentedString(this.commentText)).append("\n");
        sb.append("    commentDate: ").append(this.toIndentedString(this.commentDate)).append("\n");
        sb.append("    replyChildComments: ").append(this.toIndentedString(this.replyChildComments)).append("\n");
        sb.append("    done: ").append(this.toIndentedString(this.done)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

