/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Unit of text content in a Word Document (DOCX) file")
@JsonPropertyOrder(value={"TextIndex", "Path", "TextContent"})
@JsonTypeName(value="DocxText")
public class DocxText {
    public static final String JSON_PROPERTY_TEXT_INDEX = "TextIndex";
    private Integer textIndex;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_TEXT_CONTENT = "TextContent";
    private String textContent;

    public DocxText textIndex(Integer textIndex) {
        this.textIndex = textIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the text content in the run; 0-based")
    @JsonProperty(value="TextIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTextIndex() {
        return this.textIndex;
    }

    public void setTextIndex(Integer textIndex) {
        this.textIndex = textIndex;
    }

    public DocxText path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this Text object; leave blank for creation")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxText textContent(String textContent) {
        this.textContent = textContent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text string containing the text content of this text content item")
    @JsonProperty(value="TextContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxText docxText = (DocxText)o;
        return Objects.equals(this.textIndex, docxText.textIndex) && Objects.equals(this.path, docxText.path) && Objects.equals(this.textContent, docxText.textContent);
    }

    public int hashCode() {
        return Objects.hash(this.textIndex, this.path, this.textContent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxText {\n");
        sb.append("    textIndex: ").append(this.toIndentedString(this.textIndex)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    textContent: ").append(this.toIndentedString(this.textContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

