/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxTableCell;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A row in a Word Document (DOCX) file")
@JsonPropertyOrder(value={"RowIndex", "Path", "RowCells"})
@JsonTypeName(value="DocxTableRow")
public class DocxTableRow {
    public static final String JSON_PROPERTY_ROW_INDEX = "RowIndex";
    private Integer rowIndex;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_ROW_CELLS = "RowCells";
    private List<DocxTableCell> rowCells = null;

    public DocxTableRow rowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the row, 0-based")
    @JsonProperty(value="RowIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public DocxTableRow path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this table row object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxTableRow rowCells(List<DocxTableCell> rowCells) {
        this.rowCells = rowCells;
        return this;
    }

    public DocxTableRow addRowCellsItem(DocxTableCell rowCellsItem) {
        if (this.rowCells == null) {
            this.rowCells = new ArrayList<DocxTableCell>();
        }
        this.rowCells.add(rowCellsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cells in the row; this is where the contents of the row is stored")
    @JsonProperty(value="RowCells")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxTableCell> getRowCells() {
        return this.rowCells;
    }

    public void setRowCells(List<DocxTableCell> rowCells) {
        this.rowCells = rowCells;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxTableRow docxTableRow = (DocxTableRow)o;
        return Objects.equals(this.rowIndex, docxTableRow.rowIndex) && Objects.equals(this.path, docxTableRow.path) && Objects.equals(this.rowCells, docxTableRow.rowCells);
    }

    public int hashCode() {
        return Objects.hash(this.rowIndex, this.path, this.rowCells);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxTableRow {\n");
        sb.append("    rowIndex: ").append(this.toIndentedString(this.rowIndex)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    rowCells: ").append(this.toIndentedString(this.rowCells)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

