/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Style in a DOCX Word Document")
@JsonPropertyOrder(value={"StyleID", "Path", "Bold", "Italic", "Underline", "FontSize", "FontFamily"})
@JsonTypeName(value="DocxStyle")
public class DocxStyle {
    public static final String JSON_PROPERTY_STYLE_I_D = "StyleID";
    private String styleID;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_BOLD = "Bold";
    private Boolean bold;
    public static final String JSON_PROPERTY_ITALIC = "Italic";
    private Boolean italic;
    public static final String JSON_PROPERTY_UNDERLINE = "Underline";
    private Boolean underline;
    public static final String JSON_PROPERTY_FONT_SIZE = "FontSize";
    private String fontSize;
    public static final String JSON_PROPERTY_FONT_FAMILY = "FontFamily";
    private String fontFamily;

    public DocxStyle styleID(String styleID) {
        this.styleID = styleID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the style")
    @JsonProperty(value="StyleID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStyleID() {
        return this.styleID;
    }

    public void setStyleID(String styleID) {
        this.styleID = styleID;
    }

    public DocxStyle path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxStyle bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Style applies bold formatting")
    @JsonProperty(value="Bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public DocxStyle italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Style applies italic formatting")
    @JsonProperty(value="Italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public DocxStyle underline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Style applies underline formatting")
    @JsonProperty(value="Underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUnderline() {
        return this.underline;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public DocxStyle fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font size")
    @JsonProperty(value="FontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public DocxStyle fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font family")
    @JsonProperty(value="FontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxStyle docxStyle = (DocxStyle)o;
        return Objects.equals(this.styleID, docxStyle.styleID) && Objects.equals(this.path, docxStyle.path) && Objects.equals(this.bold, docxStyle.bold) && Objects.equals(this.italic, docxStyle.italic) && Objects.equals(this.underline, docxStyle.underline) && Objects.equals(this.fontSize, docxStyle.fontSize) && Objects.equals(this.fontFamily, docxStyle.fontFamily);
    }

    public int hashCode() {
        return Objects.hash(this.styleID, this.path, this.bold, this.italic, this.underline, this.fontSize, this.fontFamily);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxStyle {\n");
        sb.append("    styleID: ").append(this.toIndentedString(this.styleID)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    underline: ").append(this.toIndentedString(this.underline)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

