/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxText;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A content run in a Word Document (DOCX) file")
@JsonPropertyOrder(value={"RunIndex", "Path", "TextItems", "Bold", "Italic", "Underline", "FontFamily", "FontSize"})
@JsonTypeName(value="DocxRun")
public class DocxRun {
    public static final String JSON_PROPERTY_RUN_INDEX = "RunIndex";
    private Integer runIndex;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_TEXT_ITEMS = "TextItems";
    private List<DocxText> textItems = null;
    public static final String JSON_PROPERTY_BOLD = "Bold";
    private Boolean bold;
    public static final String JSON_PROPERTY_ITALIC = "Italic";
    private Boolean italic;
    public static final String JSON_PROPERTY_UNDERLINE = "Underline";
    private String underline;
    public static final String JSON_PROPERTY_FONT_FAMILY = "FontFamily";
    private String fontFamily;
    public static final String JSON_PROPERTY_FONT_SIZE = "FontSize";
    private String fontSize;

    public DocxRun runIndex(Integer runIndex) {
        this.runIndex = runIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of the run, 0-based")
    @JsonProperty(value="RunIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRunIndex() {
        return this.runIndex;
    }

    public void setRunIndex(Integer runIndex) {
        this.runIndex = runIndex;
    }

    public DocxRun path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this Run object; leave blank for creation")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxRun textItems(List<DocxText> textItems) {
        this.textItems = textItems;
        return this;
    }

    public DocxRun addTextItemsItem(DocxText textItemsItem) {
        if (this.textItems == null) {
            this.textItems = new ArrayList<DocxText>();
        }
        this.textItems.add(textItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text items inside the run; this is where the actual text content is stored")
    @JsonProperty(value="TextItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxText> getTextItems() {
        return this.textItems;
    }

    public void setTextItems(List<DocxText> textItems) {
        this.textItems = textItems;
    }

    public DocxRun bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True to make the text bold, false otherwise")
    @JsonProperty(value="Bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public DocxRun italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True to make the text italic, false otherwise")
    @JsonProperty(value="Italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public DocxRun underline(String underline) {
        this.underline = underline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Underline mode for the text; possible values are: Words, Double, Thick, Dotted, DottedHeavy, Dash, DashedHeavy, DashLong, DashLongHeavy, DotDash, DashDotHeavy, DotDotDash, DashDotDotHeavy, Wave, WavyHeavy, WavyDouble, None")
    @JsonProperty(value="Underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUnderline() {
        return this.underline;
    }

    public void setUnderline(String underline) {
        this.underline = underline;
    }

    public DocxRun fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font Family name for the text, e.g. \"Arial\" or \"Times New Roman\"")
    @JsonProperty(value="FontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public DocxRun fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Font size in font points (e.g. \"24\")")
    @JsonProperty(value="FontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxRun docxRun = (DocxRun)o;
        return Objects.equals(this.runIndex, docxRun.runIndex) && Objects.equals(this.path, docxRun.path) && Objects.equals(this.textItems, docxRun.textItems) && Objects.equals(this.bold, docxRun.bold) && Objects.equals(this.italic, docxRun.italic) && Objects.equals(this.underline, docxRun.underline) && Objects.equals(this.fontFamily, docxRun.fontFamily) && Objects.equals(this.fontSize, docxRun.fontSize);
    }

    public int hashCode() {
        return Objects.hash(this.runIndex, this.path, this.textItems, this.bold, this.italic, this.underline, this.fontFamily, this.fontSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxRun {\n");
        sb.append("    runIndex: ").append(this.toIndentedString(this.runIndex)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    textItems: ").append(this.toIndentedString(this.textItems)).append("\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    underline: ").append(this.toIndentedString(this.underline)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

