/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxRun;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A paragraph in a Word Document (DOCX) file; there is where text, content and formatting are stored - similar to the paragraph tag in HTML")
@JsonPropertyOrder(value={"ParagraphIndex", "Path", "ContentRuns", "StyleID"})
@JsonTypeName(value="DocxParagraph")
public class DocxParagraph {
    public static final String JSON_PROPERTY_PARAGRAPH_INDEX = "ParagraphIndex";
    private Integer paragraphIndex;
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_CONTENT_RUNS = "ContentRuns";
    private List<DocxRun> contentRuns = null;
    public static final String JSON_PROPERTY_STYLE_I_D = "StyleID";
    private String styleID;

    public DocxParagraph paragraphIndex(Integer paragraphIndex) {
        this.paragraphIndex = paragraphIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The index of the paragraph; 0-based")
    @JsonProperty(value="ParagraphIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getParagraphIndex() {
        return this.paragraphIndex;
    }

    public void setParagraphIndex(Integer paragraphIndex) {
        this.paragraphIndex = paragraphIndex;
    }

    public DocxParagraph path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this Paragraph object; leave blank during creation")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxParagraph contentRuns(List<DocxRun> contentRuns) {
        this.contentRuns = contentRuns;
        return this;
    }

    public DocxParagraph addContentRunsItem(DocxRun contentRunsItem) {
        if (this.contentRuns == null) {
            this.contentRuns = new ArrayList<DocxRun>();
        }
        this.contentRuns.add(contentRunsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The content runs in the paragraph - this is where text is stored; similar to a span in HTML")
    @JsonProperty(value="ContentRuns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxRun> getContentRuns() {
        return this.contentRuns;
    }

    public void setContentRuns(List<DocxRun> contentRuns) {
        this.contentRuns = contentRuns;
    }

    public DocxParagraph styleID(String styleID) {
        this.styleID = styleID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Style ID of the style applied to the paragraph; null if no style is applied")
    @JsonProperty(value="StyleID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStyleID() {
        return this.styleID;
    }

    public void setStyleID(String styleID) {
        this.styleID = styleID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxParagraph docxParagraph = (DocxParagraph)o;
        return Objects.equals(this.paragraphIndex, docxParagraph.paragraphIndex) && Objects.equals(this.path, docxParagraph.path) && Objects.equals(this.contentRuns, docxParagraph.contentRuns) && Objects.equals(this.styleID, docxParagraph.styleID);
    }

    public int hashCode() {
        return Objects.hash(this.paragraphIndex, this.path, this.contentRuns, this.styleID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxParagraph {\n");
        sb.append("    paragraphIndex: ").append(this.toIndentedString(this.paragraphIndex)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    contentRuns: ").append(this.toIndentedString(this.contentRuns)).append("\n");
        sb.append("    styleID: ").append(this.toIndentedString(this.styleID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

