/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxImage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to set-footer command")
@JsonPropertyOrder(value={"InputDocumentFileBytes", "InputDocumentFileUrl", "InputImageFileBytes", "InputImageFileUrl", "ImageToAdd", "InsertPlacement", "InsertPath", "WidthInEMUs", "HeightInEMUs"})
@JsonTypeName(value="DocxInsertImageRequest")
public class DocxInsertImageRequest {
    public static final String JSON_PROPERTY_INPUT_DOCUMENT_FILE_BYTES = "InputDocumentFileBytes";
    private byte[] inputDocumentFileBytes;
    public static final String JSON_PROPERTY_INPUT_DOCUMENT_FILE_URL = "InputDocumentFileUrl";
    private String inputDocumentFileUrl;
    public static final String JSON_PROPERTY_INPUT_IMAGE_FILE_BYTES = "InputImageFileBytes";
    private byte[] inputImageFileBytes;
    public static final String JSON_PROPERTY_INPUT_IMAGE_FILE_URL = "InputImageFileUrl";
    private String inputImageFileUrl;
    public static final String JSON_PROPERTY_IMAGE_TO_ADD = "ImageToAdd";
    private DocxImage imageToAdd;
    public static final String JSON_PROPERTY_INSERT_PLACEMENT = "InsertPlacement";
    private String insertPlacement;
    public static final String JSON_PROPERTY_INSERT_PATH = "InsertPath";
    private String insertPath;
    public static final String JSON_PROPERTY_WIDTH_IN_E_M_US = "WidthInEMUs";
    private Long widthInEMUs;
    public static final String JSON_PROPERTY_HEIGHT_IN_E_M_US = "HeightInEMUs";
    private Long heightInEMUs;

    public DocxInsertImageRequest inputDocumentFileBytes(byte[] inputDocumentFileBytes) {
        this.inputDocumentFileBytes = inputDocumentFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputDocumentFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputDocumentFileBytes() {
        return this.inputDocumentFileBytes;
    }

    public void setInputDocumentFileBytes(byte[] inputDocumentFileBytes) {
        this.inputDocumentFileBytes = inputDocumentFileBytes;
    }

    public DocxInsertImageRequest inputDocumentFileUrl(String inputDocumentFileUrl) {
        this.inputDocumentFileUrl = inputDocumentFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputDocumentFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputDocumentFileUrl() {
        return this.inputDocumentFileUrl;
    }

    public void setInputDocumentFileUrl(String inputDocumentFileUrl) {
        this.inputDocumentFileUrl = inputDocumentFileUrl;
    }

    public DocxInsertImageRequest inputImageFileBytes(byte[] inputImageFileBytes) {
        this.inputImageFileBytes = inputImageFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input image file to operate on; if you supply this value do not supply InputImageFileUrl or ImageToAdd.")
    @JsonProperty(value="InputImageFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputImageFileBytes() {
        return this.inputImageFileBytes;
    }

    public void setInputImageFileBytes(byte[] inputImageFileBytes) {
        this.inputImageFileBytes = inputImageFileBytes;
    }

    public DocxInsertImageRequest inputImageFileUrl(String inputImageFileUrl) {
        this.inputImageFileUrl = inputImageFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of an image file to operate on as input; if you supply this value do not supply InputImageFileBytes or ImageToAdd.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputImageFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputImageFileUrl() {
        return this.inputImageFileUrl;
    }

    public void setInputImageFileUrl(String inputImageFileUrl) {
        this.inputImageFileUrl = inputImageFileUrl;
    }

    public DocxInsertImageRequest imageToAdd(DocxImage imageToAdd) {
        this.imageToAdd = imageToAdd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="ImageToAdd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocxImage getImageToAdd() {
        return this.imageToAdd;
    }

    public void setImageToAdd(DocxImage imageToAdd) {
        this.imageToAdd = imageToAdd;
    }

    public DocxInsertImageRequest insertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; default is DocumentEnd.  Placement Type of the insert; possible values are: DocumentStart (very beginning of the document), DocumentEnd (very end of the document), BeforeExistingObject (right before an existing object - fill in the InsertPath field using the Path value from an existing object), AfterExistingObject (right after an existing object - fill in the InsertPath field using the Path value from an existing object)")
    @JsonProperty(value="InsertPlacement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsertPlacement() {
        return this.insertPlacement;
    }

    public void setInsertPlacement(String insertPlacement) {
        this.insertPlacement = insertPlacement;
    }

    public DocxInsertImageRequest insertPath(String insertPath) {
        this.insertPath = insertPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; location within the document to insert the object; fill in the InsertPath field using the Path value from an existing object.  Used with InsertPlacement of BeforeExistingObject or AfterExistingObject")
    @JsonProperty(value="InsertPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInsertPath() {
        return this.insertPath;
    }

    public void setInsertPath(String insertPath) {
        this.insertPath = insertPath;
    }

    public DocxInsertImageRequest widthInEMUs(Long widthInEMUs) {
        this.widthInEMUs = widthInEMUs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: The width of the image in EMUs")
    @JsonProperty(value="WidthInEMUs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getWidthInEMUs() {
        return this.widthInEMUs;
    }

    public void setWidthInEMUs(Long widthInEMUs) {
        this.widthInEMUs = widthInEMUs;
    }

    public DocxInsertImageRequest heightInEMUs(Long heightInEMUs) {
        this.heightInEMUs = heightInEMUs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: The height of the image in EMUs")
    @JsonProperty(value="HeightInEMUs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHeightInEMUs() {
        return this.heightInEMUs;
    }

    public void setHeightInEMUs(Long heightInEMUs) {
        this.heightInEMUs = heightInEMUs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxInsertImageRequest docxInsertImageRequest = (DocxInsertImageRequest)o;
        return Arrays.equals(this.inputDocumentFileBytes, docxInsertImageRequest.inputDocumentFileBytes) && Objects.equals(this.inputDocumentFileUrl, docxInsertImageRequest.inputDocumentFileUrl) && Arrays.equals(this.inputImageFileBytes, docxInsertImageRequest.inputImageFileBytes) && Objects.equals(this.inputImageFileUrl, docxInsertImageRequest.inputImageFileUrl) && Objects.equals(this.imageToAdd, docxInsertImageRequest.imageToAdd) && Objects.equals(this.insertPlacement, docxInsertImageRequest.insertPlacement) && Objects.equals(this.insertPath, docxInsertImageRequest.insertPath) && Objects.equals(this.widthInEMUs, docxInsertImageRequest.widthInEMUs) && Objects.equals(this.heightInEMUs, docxInsertImageRequest.heightInEMUs);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputDocumentFileBytes), this.inputDocumentFileUrl, Arrays.hashCode(this.inputImageFileBytes), this.inputImageFileUrl, this.imageToAdd, this.insertPlacement, this.insertPath, this.widthInEMUs, this.heightInEMUs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxInsertImageRequest {\n");
        sb.append("    inputDocumentFileBytes: ").append(this.toIndentedString(this.inputDocumentFileBytes)).append("\n");
        sb.append("    inputDocumentFileUrl: ").append(this.toIndentedString(this.inputDocumentFileUrl)).append("\n");
        sb.append("    inputImageFileBytes: ").append(this.toIndentedString(this.inputImageFileBytes)).append("\n");
        sb.append("    inputImageFileUrl: ").append(this.toIndentedString(this.inputImageFileUrl)).append("\n");
        sb.append("    imageToAdd: ").append(this.toIndentedString(this.imageToAdd)).append("\n");
        sb.append("    insertPlacement: ").append(this.toIndentedString(this.insertPlacement)).append("\n");
        sb.append("    insertPath: ").append(this.toIndentedString(this.insertPath)).append("\n");
        sb.append("    widthInEMUs: ").append(this.toIndentedString(this.widthInEMUs)).append("\n");
        sb.append("    heightInEMUs: ").append(this.toIndentedString(this.heightInEMUs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

