/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocxParagraph;
import com.cloudmersive.client.rt.model.DocxSection;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Footer in a Word Document (DOCX)")
@JsonPropertyOrder(value={"Path", "Paragraphs", "SectionsWithFooter"})
@JsonTypeName(value="DocxFooter")
public class DocxFooter {
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_PARAGRAPHS = "Paragraphs";
    private List<DocxParagraph> paragraphs = null;
    public static final String JSON_PROPERTY_SECTIONS_WITH_FOOTER = "SectionsWithFooter";
    private List<DocxSection> sectionsWithFooter = null;

    public DocxFooter path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new tables")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocxFooter paragraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public DocxFooter addParagraphsItem(DocxParagraph paragraphsItem) {
        if (this.paragraphs == null) {
            this.paragraphs = new ArrayList<DocxParagraph>();
        }
        this.paragraphs.add(paragraphsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Paragraphs in this footer")
    @JsonProperty(value="Paragraphs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(List<DocxParagraph> paragraphs) {
        this.paragraphs = paragraphs;
    }

    public DocxFooter sectionsWithFooter(List<DocxSection> sectionsWithFooter) {
        this.sectionsWithFooter = sectionsWithFooter;
        return this;
    }

    public DocxFooter addSectionsWithFooterItem(DocxSection sectionsWithFooterItem) {
        if (this.sectionsWithFooter == null) {
            this.sectionsWithFooter = new ArrayList<DocxSection>();
        }
        this.sectionsWithFooter.add(sectionsWithFooterItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sections that the footer is applied to")
    @JsonProperty(value="SectionsWithFooter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocxSection> getSectionsWithFooter() {
        return this.sectionsWithFooter;
    }

    public void setSectionsWithFooter(List<DocxSection> sectionsWithFooter) {
        this.sectionsWithFooter = sectionsWithFooter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocxFooter docxFooter = (DocxFooter)o;
        return Objects.equals(this.path, docxFooter.path) && Objects.equals(this.paragraphs, docxFooter.paragraphs) && Objects.equals(this.sectionsWithFooter, docxFooter.sectionsWithFooter);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.paragraphs, this.sectionsWithFooter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocxFooter {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("    sectionsWithFooter: ").append(this.toIndentedString(this.sectionsWithFooter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

