/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ZipDirectory;
import com.cloudmersive.client.rt.model.ZipFile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to create a Zip Archive")
@JsonPropertyOrder(value={"FilesInZip", "DirectoriesInZip"})
@JsonTypeName(value="CreateZipArchiveRequest")
public class CreateZipArchiveRequest {
    public static final String JSON_PROPERTY_FILES_IN_ZIP = "FilesInZip";
    private List<ZipFile> filesInZip = null;
    public static final String JSON_PROPERTY_DIRECTORIES_IN_ZIP = "DirectoriesInZip";
    private List<ZipDirectory> directoriesInZip = null;

    public CreateZipArchiveRequest filesInZip(List<ZipFile> filesInZip) {
        this.filesInZip = filesInZip;
        return this;
    }

    public CreateZipArchiveRequest addFilesInZipItem(ZipFile filesInZipItem) {
        if (this.filesInZip == null) {
            this.filesInZip = new ArrayList<ZipFile>();
        }
        this.filesInZip.add(filesInZipItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top-level files in the root directory fo the zip file")
    @JsonProperty(value="FilesInZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipFile> getFilesInZip() {
        return this.filesInZip;
    }

    public void setFilesInZip(List<ZipFile> filesInZip) {
        this.filesInZip = filesInZip;
    }

    public CreateZipArchiveRequest directoriesInZip(List<ZipDirectory> directoriesInZip) {
        this.directoriesInZip = directoriesInZip;
        return this;
    }

    public CreateZipArchiveRequest addDirectoriesInZipItem(ZipDirectory directoriesInZipItem) {
        if (this.directoriesInZip == null) {
            this.directoriesInZip = new ArrayList<ZipDirectory>();
        }
        this.directoriesInZip.add(directoriesInZipItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top-level directories in the root directory of the zip; directories can contain sub-directories and files")
    @JsonProperty(value="DirectoriesInZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipDirectory> getDirectoriesInZip() {
        return this.directoriesInZip;
    }

    public void setDirectoriesInZip(List<ZipDirectory> directoriesInZip) {
        this.directoriesInZip = directoriesInZip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateZipArchiveRequest createZipArchiveRequest = (CreateZipArchiveRequest)o;
        return Objects.equals(this.filesInZip, createZipArchiveRequest.filesInZip) && Objects.equals(this.directoriesInZip, createZipArchiveRequest.directoriesInZip);
    }

    public int hashCode() {
        return Objects.hash(this.filesInZip, this.directoriesInZip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateZipArchiveRequest {\n");
        sb.append("    filesInZip: ").append(this.toIndentedString(this.filesInZip)).append("\n");
        sb.append("    directoriesInZip: ").append(this.toIndentedString(this.directoriesInZip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

