/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxSpreadsheetRow;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to Create a new Spreadsheet request")
@JsonPropertyOrder(value={"WorksheetName", "Rows"})
@JsonTypeName(value="CreateSpreadsheetFromDataRequest")
public class CreateSpreadsheetFromDataRequest {
    public static final String JSON_PROPERTY_WORKSHEET_NAME = "WorksheetName";
    private String worksheetName;
    public static final String JSON_PROPERTY_ROWS = "Rows";
    private List<XlsxSpreadsheetRow> rows = null;

    public CreateSpreadsheetFromDataRequest worksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional; The new Spreadsheet will have a default Worksheet in it; supply a name, or if left empty, will default to Worksheet1")
    @JsonProperty(value="WorksheetName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorksheetName() {
        return this.worksheetName;
    }

    public void setWorksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
    }

    public CreateSpreadsheetFromDataRequest rows(List<XlsxSpreadsheetRow> rows) {
        this.rows = rows;
        return this;
    }

    public CreateSpreadsheetFromDataRequest addRowsItem(XlsxSpreadsheetRow rowsItem) {
        if (this.rows == null) {
            this.rows = new ArrayList<XlsxSpreadsheetRow>();
        }
        this.rows.add(rowsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required; Rows and cells to populate the spreadsheet with")
    @JsonProperty(value="Rows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<XlsxSpreadsheetRow> getRows() {
        return this.rows;
    }

    public void setRows(List<XlsxSpreadsheetRow> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSpreadsheetFromDataRequest createSpreadsheetFromDataRequest = (CreateSpreadsheetFromDataRequest)o;
        return Objects.equals(this.worksheetName, createSpreadsheetFromDataRequest.worksheetName) && Objects.equals(this.rows, createSpreadsheetFromDataRequest.rows);
    }

    public int hashCode() {
        return Objects.hash(this.worksheetName, this.rows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSpreadsheetFromDataRequest {\n");
        sb.append("    worksheetName: ").append(this.toIndentedString(this.worksheetName)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

