/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a create setting operation")
@JsonPropertyOrder(value={"Successful", "SettingDefinitionID", "SettingValueID", "ErrorMessage"})
@JsonTypeName(value="CreateSettingResponse")
public class CreateSettingResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_SETTING_DEFINITION_I_D = "SettingDefinitionID";
    private String settingDefinitionID;
    public static final String JSON_PROPERTY_SETTING_VALUE_I_D = "SettingValueID";
    private String settingValueID;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "ErrorMessage";
    private String errorMessage;

    public CreateSettingResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public CreateSettingResponse settingDefinitionID(String settingDefinitionID) {
        this.settingDefinitionID = settingDefinitionID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SettingDefinitionID of the setting created")
    @JsonProperty(value="SettingDefinitionID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingDefinitionID() {
        return this.settingDefinitionID;
    }

    public void setSettingDefinitionID(String settingDefinitionID) {
        this.settingDefinitionID = settingDefinitionID;
    }

    public CreateSettingResponse settingValueID(String settingValueID) {
        this.settingValueID = settingValueID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SettingValueID of the value of the setting")
    @JsonProperty(value="SettingValueID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingValueID() {
        return this.settingValueID;
    }

    public void setSettingValueID(String settingValueID) {
        this.settingValueID = settingValueID;
    }

    public CreateSettingResponse errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error message, if any, when the operation was not successful")
    @JsonProperty(value="ErrorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSettingResponse createSettingResponse = (CreateSettingResponse)o;
        return Objects.equals(this.successful, createSettingResponse.successful) && Objects.equals(this.settingDefinitionID, createSettingResponse.settingDefinitionID) && Objects.equals(this.settingValueID, createSettingResponse.settingValueID) && Objects.equals(this.errorMessage, createSettingResponse.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.settingDefinitionID, this.settingValueID, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSettingResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    settingDefinitionID: ").append(this.toIndentedString(this.settingDefinitionID)).append("\n");
        sb.append("    settingValueID: ").append(this.toIndentedString(this.settingValueID)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

