/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.CountryDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of enumerating available countries")
@JsonPropertyOrder(value={"Successful", "Countries"})
@JsonTypeName(value="CountryListResult")
public class CountryListResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_COUNTRIES = "Countries";
    private List<CountryDetails> countries = null;

    public CountryListResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public CountryListResult countries(List<CountryDetails> countries) {
        this.countries = countries;
        return this;
    }

    public CountryListResult addCountriesItem(CountryDetails countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<CountryDetails>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of current ISO 3166-1 countries in the world")
    @JsonProperty(value="Countries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CountryDetails> getCountries() {
        return this.countries;
    }

    public void setCountries(List<CountryDetails> countries) {
        this.countries = countries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryListResult countryListResult = (CountryListResult)o;
        return Objects.equals(this.successful, countryListResult.successful) && Objects.equals(this.countries, countryListResult.countries);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.countries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountryListResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

