/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of one country")
@JsonPropertyOrder(value={"CountryName", "ThreeLetterCode", "ISOTwoLetterCode", "IsEuropeanUnionMember", "ISOCurrencyCode", "CurrencySymbol", "CurrencyEnglishName", "Region", "Subregion"})
@JsonTypeName(value="CountryDetails")
public class CountryDetails {
    public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
    private String countryName;
    public static final String JSON_PROPERTY_THREE_LETTER_CODE = "ThreeLetterCode";
    private String threeLetterCode;
    public static final String JSON_PROPERTY_IS_O_TWO_LETTER_CODE = "ISOTwoLetterCode";
    private String isOTwoLetterCode;
    public static final String JSON_PROPERTY_IS_EUROPEAN_UNION_MEMBER = "IsEuropeanUnionMember";
    private Boolean isEuropeanUnionMember;
    public static final String JSON_PROPERTY_IS_O_CURRENCY_CODE = "ISOCurrencyCode";
    private String isOCurrencyCode;
    public static final String JSON_PROPERTY_CURRENCY_SYMBOL = "CurrencySymbol";
    private String currencySymbol;
    public static final String JSON_PROPERTY_CURRENCY_ENGLISH_NAME = "CurrencyEnglishName";
    private String currencyEnglishName;
    public static final String JSON_PROPERTY_REGION = "Region";
    private String region;
    public static final String JSON_PROPERTY_SUBREGION = "Subregion";
    private String subregion;

    public CountryDetails countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the country")
    @JsonProperty(value="CountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public CountryDetails threeLetterCode(String threeLetterCode) {
        this.threeLetterCode = threeLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Three-letter ISO 3166-1 country code")
    @JsonProperty(value="ThreeLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public void setThreeLetterCode(String threeLetterCode) {
        this.threeLetterCode = threeLetterCode;
    }

    public CountryDetails isOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter ISO 3166-1 country code")
    @JsonProperty(value="ISOTwoLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOTwoLetterCode() {
        return this.isOTwoLetterCode;
    }

    public void setIsOTwoLetterCode(String isOTwoLetterCode) {
        this.isOTwoLetterCode = isOTwoLetterCode;
    }

    public CountryDetails isEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this country is currently a member of the European Union (EU), false otherwise")
    @JsonProperty(value="IsEuropeanUnionMember")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEuropeanUnionMember() {
        return this.isEuropeanUnionMember;
    }

    public void setIsEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
    }

    public CountryDetails isOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO 4217 currency three-letter code associated with the country")
    @JsonProperty(value="ISOCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOCurrencyCode() {
        return this.isOCurrencyCode;
    }

    public void setIsOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
    }

    public CountryDetails currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol associated with the currency")
    @JsonProperty(value="CurrencySymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public CountryDetails currencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full name of the currency")
    @JsonProperty(value="CurrencyEnglishName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyEnglishName() {
        return this.currencyEnglishName;
    }

    public void setCurrencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
    }

    public CountryDetails region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Region (continent) in which the country is located; possible values are None, Europe, Americas, Asia, Africa, Oceania")
    @JsonProperty(value="Region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public CountryDetails subregion(String subregion) {
        this.subregion = subregion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subregion in which the country is located; possible values are None, NorthernEurope, WesternEurope, SouthernEurope, EasternEurope, CentralAmerica, NorthernAmerica, SouthAmerica, EasternAfrica, MiddleAfrica, NorthernAfrica , SouthernAfrica , WesternAfrica , CentralAsia , EasternAsia , SouthernAsia , SouthEasternAsia , WesternAsia , Southern , Middle , AustraliaandNewZealand , Melanesia , Polynesia , Micronesia , Caribbean,")
    @JsonProperty(value="Subregion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubregion() {
        return this.subregion;
    }

    public void setSubregion(String subregion) {
        this.subregion = subregion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryDetails countryDetails = (CountryDetails)o;
        return Objects.equals(this.countryName, countryDetails.countryName) && Objects.equals(this.threeLetterCode, countryDetails.threeLetterCode) && Objects.equals(this.isOTwoLetterCode, countryDetails.isOTwoLetterCode) && Objects.equals(this.isEuropeanUnionMember, countryDetails.isEuropeanUnionMember) && Objects.equals(this.isOCurrencyCode, countryDetails.isOCurrencyCode) && Objects.equals(this.currencySymbol, countryDetails.currencySymbol) && Objects.equals(this.currencyEnglishName, countryDetails.currencyEnglishName) && Objects.equals(this.region, countryDetails.region) && Objects.equals(this.subregion, countryDetails.subregion);
    }

    public int hashCode() {
        return Objects.hash(this.countryName, this.threeLetterCode, this.isOTwoLetterCode, this.isEuropeanUnionMember, this.isOCurrencyCode, this.currencySymbol, this.currencyEnglishName, this.region, this.subregion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountryDetails {\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("    threeLetterCode: ").append(this.toIndentedString(this.threeLetterCode)).append("\n");
        sb.append("    isOTwoLetterCode: ").append(this.toIndentedString(this.isOTwoLetterCode)).append("\n");
        sb.append("    isEuropeanUnionMember: ").append(this.toIndentedString(this.isEuropeanUnionMember)).append("\n");
        sb.append("    isOCurrencyCode: ").append(this.toIndentedString(this.isOCurrencyCode)).append("\n");
        sb.append("    currencySymbol: ").append(this.toIndentedString(this.currencySymbol)).append("\n");
        sb.append("    currencyEnglishName: ").append(this.toIndentedString(this.currencyEnglishName)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    subregion: ").append(this.toIndentedString(this.subregion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

