/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.WordPosition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A word in a sentence")
@JsonPropertyOrder(value={"Word", "Correct", "Suggestions"})
@JsonTypeName(value="CorrectWordInSentence")
public class CorrectWordInSentence {
    public static final String JSON_PROPERTY_WORD = "Word";
    private WordPosition word;
    public static final String JSON_PROPERTY_CORRECT = "Correct";
    private Boolean correct;
    public static final String JSON_PROPERTY_SUGGESTIONS = "Suggestions";
    private List<String> suggestions = null;

    public CorrectWordInSentence word(WordPosition word) {
        this.word = word;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Word")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WordPosition getWord() {
        return this.word;
    }

    public void setWord(WordPosition word) {
        this.word = word;
    }

    public CorrectWordInSentence correct(Boolean correct) {
        this.correct = correct;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the word is spelled correctly, false otherwise")
    @JsonProperty(value="Correct")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCorrect() {
        return this.correct;
    }

    public void setCorrect(Boolean correct) {
        this.correct = correct;
    }

    public CorrectWordInSentence suggestions(List<String> suggestions) {
        this.suggestions = suggestions;
        return this;
    }

    public CorrectWordInSentence addSuggestionsItem(String suggestionsItem) {
        if (this.suggestions == null) {
            this.suggestions = new ArrayList<String>();
        }
        this.suggestions.add(suggestionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Suggested spelling improvements")
    @JsonProperty(value="Suggestions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> suggestions) {
        this.suggestions = suggestions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrectWordInSentence correctWordInSentence = (CorrectWordInSentence)o;
        return Objects.equals(this.word, correctWordInSentence.word) && Objects.equals(this.correct, correctWordInSentence.correct) && Objects.equals(this.suggestions, correctWordInSentence.suggestions);
    }

    public int hashCode() {
        return Objects.hash(this.word, this.correct, this.suggestions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorrectWordInSentence {\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("    correct: ").append(this.toIndentedString(this.correct)).append("\n");
        sb.append("    suggestions: ").append(this.toIndentedString(this.suggestions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

