/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single converted page")
@JsonPropertyOrder(value={"PageNumber", "URL"})
@JsonTypeName(value="ConvertedPngPage")
public class ConvertedPngPage {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;

    public ConvertedPngPage pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the converted page, starting with 1")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ConvertedPngPage URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to the PNG file of this page; file is stored in an in-memory cache and will be deleted")
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertedPngPage convertedPngPage = (ConvertedPngPage)o;
        return Objects.equals(this.pageNumber, convertedPngPage.pageNumber) && Objects.equals(this.URL, convertedPngPage.URL);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.URL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertedPngPage {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

