/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single converted page")
@JsonPropertyOrder(value={"PageNumber", "Content"})
@JsonTypeName(value="ConvertedJpgPage")
public class ConvertedJpgPage {
    public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
    private Integer pageNumber;
    public static final String JSON_PROPERTY_CONTENT = "Content";
    private byte[] content;

    public ConvertedJpgPage pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Page number of the converted page, starting with 1")
    @JsonProperty(value="PageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ConvertedJpgPage content(byte[] content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The JPG file of this page as a byte array")
    @JsonProperty(value="Content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertedJpgPage convertedJpgPage = (ConvertedJpgPage)o;
        return Objects.equals(this.pageNumber, convertedJpgPage.pageNumber) && Arrays.equals(this.content, convertedJpgPage.content);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, Arrays.hashCode(this.content));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertedJpgPage {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

