/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a Convert Currency operation")
@JsonPropertyOrder(value={"ConvertedPrice", "ISOCurrencyCode", "CurrencySymbol", "FormattedPriceAsString"})
@JsonTypeName(value="ConvertedCurrencyResult")
public class ConvertedCurrencyResult {
    public static final String JSON_PROPERTY_CONVERTED_PRICE = "ConvertedPrice";
    private Double convertedPrice;
    public static final String JSON_PROPERTY_IS_O_CURRENCY_CODE = "ISOCurrencyCode";
    private String isOCurrencyCode;
    public static final String JSON_PROPERTY_CURRENCY_SYMBOL = "CurrencySymbol";
    private String currencySymbol;
    public static final String JSON_PROPERTY_FORMATTED_PRICE_AS_STRING = "FormattedPriceAsString";
    private String formattedPriceAsString;

    public ConvertedCurrencyResult convertedPrice(Double convertedPrice) {
        this.convertedPrice = convertedPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The converted price in the destination currency")
    @JsonProperty(value="ConvertedPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getConvertedPrice() {
        return this.convertedPrice;
    }

    public void setConvertedPrice(Double convertedPrice) {
        this.convertedPrice = convertedPrice;
    }

    public ConvertedCurrencyResult isOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO 4217 currency three-letter code of destination price")
    @JsonProperty(value="ISOCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOCurrencyCode() {
        return this.isOCurrencyCode;
    }

    public void setIsOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
    }

    public ConvertedCurrencyResult currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Destination currency symbol")
    @JsonProperty(value="CurrencySymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public ConvertedCurrencyResult formattedPriceAsString(String formattedPriceAsString) {
        this.formattedPriceAsString = formattedPriceAsString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Formatted price in the destination currency as a string")
    @JsonProperty(value="FormattedPriceAsString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormattedPriceAsString() {
        return this.formattedPriceAsString;
    }

    public void setFormattedPriceAsString(String formattedPriceAsString) {
        this.formattedPriceAsString = formattedPriceAsString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertedCurrencyResult convertedCurrencyResult = (ConvertedCurrencyResult)o;
        return Objects.equals(this.convertedPrice, convertedCurrencyResult.convertedPrice) && Objects.equals(this.isOCurrencyCode, convertedCurrencyResult.isOCurrencyCode) && Objects.equals(this.currencySymbol, convertedCurrencyResult.currencySymbol) && Objects.equals(this.formattedPriceAsString, convertedCurrencyResult.formattedPriceAsString);
    }

    public int hashCode() {
        return Objects.hash(this.convertedPrice, this.isOCurrencyCode, this.currencySymbol, this.formattedPriceAsString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertedCurrencyResult {\n");
        sb.append("    convertedPrice: ").append(this.toIndentedString(this.convertedPrice)).append("\n");
        sb.append("    isOCurrencyCode: ").append(this.toIndentedString(this.isOCurrencyCode)).append("\n");
        sb.append("    currencySymbol: ").append(this.toIndentedString(this.currencySymbol)).append("\n");
        sb.append("    formattedPriceAsString: ").append(this.toIndentedString(this.formattedPriceAsString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

