/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Spelling correction check result")
@JsonPropertyOrder(value={"Correct", "Suggestions"})
@JsonTypeName(value="CheckWordResponse")
public class CheckWordResponse {
    public static final String JSON_PROPERTY_CORRECT = "Correct";
    private Boolean correct;
    public static final String JSON_PROPERTY_SUGGESTIONS = "Suggestions";
    private List<String> suggestions = null;

    public CheckWordResponse correct(Boolean correct) {
        this.correct = correct;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the word is spelled correctly, false otherwise")
    @JsonProperty(value="Correct")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCorrect() {
        return this.correct;
    }

    public void setCorrect(Boolean correct) {
        this.correct = correct;
    }

    public CheckWordResponse suggestions(List<String> suggestions) {
        this.suggestions = suggestions;
        return this;
    }

    public CheckWordResponse addSuggestionsItem(String suggestionsItem) {
        if (this.suggestions == null) {
            this.suggestions = new ArrayList<String>();
        }
        this.suggestions.add(suggestionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Suggested spelling corrections")
    @JsonProperty(value="Suggestions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> suggestions) {
        this.suggestions = suggestions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckWordResponse checkWordResponse = (CheckWordResponse)o;
        return Objects.equals(this.correct, checkWordResponse.correct) && Objects.equals(this.suggestions, checkWordResponse.suggestions);
    }

    public int hashCode() {
        return Objects.hash(this.correct, this.suggestions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckWordResponse {\n");
        sb.append("    correct: ").append(this.toIndentedString(this.correct)).append("\n");
        sb.append("    suggestions: ").append(this.toIndentedString(this.suggestions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

