/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ProductMatch;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a barcode lookup")
@JsonPropertyOrder(value={"Successful", "Matches"})
@JsonTypeName(value="BarcodeLookupResponse")
public class BarcodeLookupResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_MATCHES = "Matches";
    private List<ProductMatch> matches = null;

    public BarcodeLookupResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public BarcodeLookupResponse matches(List<ProductMatch> matches) {
        this.matches = matches;
        return this;
    }

    public BarcodeLookupResponse addMatchesItem(ProductMatch matchesItem) {
        if (this.matches == null) {
            this.matches = new ArrayList<ProductMatch>();
        }
        this.matches.add(matchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resulting product matches for the input barcode")
    @JsonProperty(value="Matches")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ProductMatch> getMatches() {
        return this.matches;
    }

    public void setMatches(List<ProductMatch> matches) {
        this.matches = matches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarcodeLookupResponse barcodeLookupResponse = (BarcodeLookupResponse)o;
        return Objects.equals(this.successful, barcodeLookupResponse.successful) && Objects.equals(this.matches, barcodeLookupResponse.matches);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.matches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BarcodeLookupResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    matches: ").append(this.toIndentedString(this.matches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

