/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.DocumentValidationError;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Document validation result")
@JsonPropertyOrder(value={"FileFormatExtension", "DocumentIsValid", "ErrorCount", "WarningCount", "ErrorsAndWarnings"})
@JsonTypeName(value="AutodetectDocumentValidationResult")
public class AutodetectDocumentValidationResult {
    public static final String JSON_PROPERTY_FILE_FORMAT_EXTENSION = "FileFormatExtension";
    private String fileFormatExtension;
    public static final String JSON_PROPERTY_DOCUMENT_IS_VALID = "DocumentIsValid";
    private Boolean documentIsValid;
    public static final String JSON_PROPERTY_ERROR_COUNT = "ErrorCount";
    private Integer errorCount;
    public static final String JSON_PROPERTY_WARNING_COUNT = "WarningCount";
    private Integer warningCount;
    public static final String JSON_PROPERTY_ERRORS_AND_WARNINGS = "ErrorsAndWarnings";
    private List<DocumentValidationError> errorsAndWarnings = null;

    public AutodetectDocumentValidationResult fileFormatExtension(String fileFormatExtension) {
        this.fileFormatExtension = fileFormatExtension;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="FileFormatExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileFormatExtension() {
        return this.fileFormatExtension;
    }

    public void setFileFormatExtension(String fileFormatExtension) {
        this.fileFormatExtension = fileFormatExtension;
    }

    public AutodetectDocumentValidationResult documentIsValid(Boolean documentIsValid) {
        this.documentIsValid = documentIsValid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the document is valid and has no errors, false otherwise")
    @JsonProperty(value="DocumentIsValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDocumentIsValid() {
        return this.documentIsValid;
    }

    public void setDocumentIsValid(Boolean documentIsValid) {
        this.documentIsValid = documentIsValid;
    }

    public AutodetectDocumentValidationResult errorCount(Integer errorCount) {
        this.errorCount = errorCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of validation errors found in the document")
    @JsonProperty(value="ErrorCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public AutodetectDocumentValidationResult warningCount(Integer warningCount) {
        this.warningCount = warningCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of validation warnings found in the document")
    @JsonProperty(value="WarningCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(Integer warningCount) {
        this.warningCount = warningCount;
    }

    public AutodetectDocumentValidationResult errorsAndWarnings(List<DocumentValidationError> errorsAndWarnings) {
        this.errorsAndWarnings = errorsAndWarnings;
        return this;
    }

    public AutodetectDocumentValidationResult addErrorsAndWarningsItem(DocumentValidationError errorsAndWarningsItem) {
        if (this.errorsAndWarnings == null) {
            this.errorsAndWarnings = new ArrayList<DocumentValidationError>();
        }
        this.errorsAndWarnings.add(errorsAndWarningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details of errors and warnings found")
    @JsonProperty(value="ErrorsAndWarnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentValidationError> getErrorsAndWarnings() {
        return this.errorsAndWarnings;
    }

    public void setErrorsAndWarnings(List<DocumentValidationError> errorsAndWarnings) {
        this.errorsAndWarnings = errorsAndWarnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutodetectDocumentValidationResult autodetectDocumentValidationResult = (AutodetectDocumentValidationResult)o;
        return Objects.equals(this.fileFormatExtension, autodetectDocumentValidationResult.fileFormatExtension) && Objects.equals(this.documentIsValid, autodetectDocumentValidationResult.documentIsValid) && Objects.equals(this.errorCount, autodetectDocumentValidationResult.errorCount) && Objects.equals(this.warningCount, autodetectDocumentValidationResult.warningCount) && Objects.equals(this.errorsAndWarnings, autodetectDocumentValidationResult.errorsAndWarnings);
    }

    public int hashCode() {
        return Objects.hash(this.fileFormatExtension, this.documentIsValid, this.errorCount, this.warningCount, this.errorsAndWarnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutodetectDocumentValidationResult {\n");
        sb.append("    fileFormatExtension: ").append(this.toIndentedString(this.fileFormatExtension)).append("\n");
        sb.append("    documentIsValid: ").append(this.toIndentedString(this.documentIsValid)).append("\n");
        sb.append("    errorCount: ").append(this.toIndentedString(this.errorCount)).append("\n");
        sb.append("    warningCount: ").append(this.toIndentedString(this.warningCount)).append("\n");
        sb.append("    errorsAndWarnings: ").append(this.toIndentedString(this.errorsAndWarnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

