/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PersonWithAge;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result from classifying the Age of people in an image")
@JsonPropertyOrder(value={"Successful", "PeopleWithAge", "PeopleIdentified"})
@JsonTypeName(value="AgeDetectionResult")
public class AgeDetectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PEOPLE_WITH_AGE = "PeopleWithAge";
    private List<PersonWithAge> peopleWithAge = null;
    public static final String JSON_PROPERTY_PEOPLE_IDENTIFIED = "PeopleIdentified";
    private Integer peopleIdentified;

    public AgeDetectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public AgeDetectionResult peopleWithAge(List<PersonWithAge> peopleWithAge) {
        this.peopleWithAge = peopleWithAge;
        return this;
    }

    public AgeDetectionResult addPeopleWithAgeItem(PersonWithAge peopleWithAgeItem) {
        if (this.peopleWithAge == null) {
            this.peopleWithAge = new ArrayList<PersonWithAge>();
        }
        this.peopleWithAge.add(peopleWithAgeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="People in the image annotated with age information")
    @JsonProperty(value="PeopleWithAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PersonWithAge> getPeopleWithAge() {
        return this.peopleWithAge;
    }

    public void setPeopleWithAge(List<PersonWithAge> peopleWithAge) {
        this.peopleWithAge = peopleWithAge;
    }

    public AgeDetectionResult peopleIdentified(Integer peopleIdentified) {
        this.peopleIdentified = peopleIdentified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of people identified in the image with an age")
    @JsonProperty(value="PeopleIdentified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPeopleIdentified() {
        return this.peopleIdentified;
    }

    public void setPeopleIdentified(Integer peopleIdentified) {
        this.peopleIdentified = peopleIdentified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgeDetectionResult ageDetectionResult = (AgeDetectionResult)o;
        return Objects.equals(this.successful, ageDetectionResult.successful) && Objects.equals(this.peopleWithAge, ageDetectionResult.peopleWithAge) && Objects.equals(this.peopleIdentified, ageDetectionResult.peopleIdentified);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.peopleWithAge, this.peopleIdentified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgeDetectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    peopleWithAge: ").append(this.toIndentedString(this.peopleWithAge)).append("\n");
        sb.append("    peopleIdentified: ").append(this.toIndentedString(this.peopleIdentified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

