/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.PdfAnnotation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to add annotations to a PDF")
@JsonPropertyOrder(value={"InputFileBytes", "AnnotationsToAdd"})
@JsonTypeName(value="AddPdfAnnotationRequest")
public class AddPdfAnnotationRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_ANNOTATIONS_TO_ADD = "AnnotationsToAdd";
    private List<PdfAnnotation> annotationsToAdd = null;

    public AddPdfAnnotationRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Input file contents bytes for the file to modify")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public AddPdfAnnotationRequest annotationsToAdd(List<PdfAnnotation> annotationsToAdd) {
        this.annotationsToAdd = annotationsToAdd;
        return this;
    }

    public AddPdfAnnotationRequest addAnnotationsToAddItem(PdfAnnotation annotationsToAddItem) {
        if (this.annotationsToAdd == null) {
            this.annotationsToAdd = new ArrayList<PdfAnnotation>();
        }
        this.annotationsToAdd.add(annotationsToAddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations to add to the PDF file")
    @JsonProperty(value="AnnotationsToAdd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PdfAnnotation> getAnnotationsToAdd() {
        return this.annotationsToAdd;
    }

    public void setAnnotationsToAdd(List<PdfAnnotation> annotationsToAdd) {
        this.annotationsToAdd = annotationsToAdd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddPdfAnnotationRequest addPdfAnnotationRequest = (AddPdfAnnotationRequest)o;
        return Arrays.equals(this.inputFileBytes, addPdfAnnotationRequest.inputFileBytes) && Objects.equals(this.annotationsToAdd, addPdfAnnotationRequest.annotationsToAdd);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.annotationsToAdd);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddPdfAnnotationRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    annotationsToAdd: ").append(this.toIndentedString(this.annotationsToAdd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

