/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.FindSymbolResult;
import com.cloudmersive.client.rt.model.FineTextDetectionResult;
import com.cloudmersive.client.rt.model.ImageDescriptionResponse;
import com.cloudmersive.client.rt.model.ObjectDetectionResult;
import com.cloudmersive.client.rt.model.TextDetectionResult;
import com.cloudmersive.client.rt.model.VehicleLicensePlateDetectionResult;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.RecognizeApi")
public class RecognizeApi {
    private ApiClient apiClient;

    public RecognizeApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecognizeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ImageDescriptionResponse recognizeDescribe(Resource imageFile) throws RestClientException {
        return (ImageDescriptionResponse)this.recognizeDescribeWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<ImageDescriptionResponse> recognizeDescribeWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDescribe");
        }
        String path = this.apiClient.expandPath("/image/recognize/describe", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ImageDescriptionResponse> returnType = new ParameterizedTypeReference<ImageDescriptionResponse>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] recognizeDetectAndUnskewDocument(Resource imageFile, String postProcessingEffect) throws RestClientException {
        return (byte[])this.recognizeDetectAndUnskewDocumentWithHttpInfo(imageFile, postProcessingEffect).getBody();
    }

    public ResponseEntity<byte[]> recognizeDetectAndUnskewDocumentWithHttpInfo(Resource imageFile, String postProcessingEffect) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectAndUnskewDocument");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-document/unskew", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (postProcessingEffect != null) {
            headerParams.add("PostProcessingEffect", this.apiClient.parameterToString(postProcessingEffect));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ObjectDetectionResult recognizeDetectObjects(Resource imageFile) throws RestClientException {
        return (ObjectDetectionResult)this.recognizeDetectObjectsWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<ObjectDetectionResult> recognizeDetectObjectsWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectObjects");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-objects", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ObjectDetectionResult> returnType = new ParameterizedTypeReference<ObjectDetectionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ObjectDetectionResult recognizeDetectPeople(Resource imageFile) throws RestClientException {
        return (ObjectDetectionResult)this.recognizeDetectPeopleWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<ObjectDetectionResult> recognizeDetectPeopleWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectPeople");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-people", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ObjectDetectionResult> returnType = new ParameterizedTypeReference<ObjectDetectionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public FineTextDetectionResult recognizeDetectTextFine(Resource imageFile) throws RestClientException {
        return (FineTextDetectionResult)this.recognizeDetectTextFineWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<FineTextDetectionResult> recognizeDetectTextFineWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectTextFine");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-text/fine", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<FineTextDetectionResult> returnType = new ParameterizedTypeReference<FineTextDetectionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public TextDetectionResult recognizeDetectTextLarge(Resource imageFile) throws RestClientException {
        return (TextDetectionResult)this.recognizeDetectTextLargeWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<TextDetectionResult> recognizeDetectTextLargeWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectTextLarge");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-text/large", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<TextDetectionResult> returnType = new ParameterizedTypeReference<TextDetectionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public VehicleLicensePlateDetectionResult recognizeDetectVehicleLicensePlates(Resource imageFile) throws RestClientException {
        return (VehicleLicensePlateDetectionResult)this.recognizeDetectVehicleLicensePlatesWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<VehicleLicensePlateDetectionResult> recognizeDetectVehicleLicensePlatesWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling recognizeDetectVehicleLicensePlates");
        }
        String path = this.apiClient.expandPath("/image/recognize/detect-vehicle-license-plates", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<VehicleLicensePlateDetectionResult> returnType = new ParameterizedTypeReference<VehicleLicensePlateDetectionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public FindSymbolResult recognizeFindSymbol(Resource inputImage, Resource targetImage) throws RestClientException {
        return (FindSymbolResult)this.recognizeFindSymbolWithHttpInfo(inputImage, targetImage).getBody();
    }

    public ResponseEntity<FindSymbolResult> recognizeFindSymbolWithHttpInfo(Resource inputImage, Resource targetImage) throws RestClientException {
        Object postBody = null;
        if (inputImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputImage' when calling recognizeFindSymbol");
        }
        if (targetImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetImage' when calling recognizeFindSymbol");
        }
        String path = this.apiClient.expandPath("/image/recognize/find/symbol", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputImage != null) {
            formParams.add((Object)"inputImage", (Object)inputImage);
        }
        if (targetImage != null) {
            formParams.add((Object)"targetImage", (Object)targetImage);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<FindSymbolResult> returnType = new ParameterizedTypeReference<FindSymbolResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

