/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.GetPageAngleResult;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.PreprocessingApi")
public class PreprocessingApi {
    private ApiClient apiClient;

    public PreprocessingApi() {
        this(new ApiClient());
    }

    @Autowired
    public PreprocessingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] preprocessingBinarize(Resource imageFile) throws RestClientException {
        return (byte[])this.preprocessingBinarizeWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> preprocessingBinarizeWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingBinarize");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/binarize", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] preprocessingBinarizeAdvanced(Resource imageFile) throws RestClientException {
        return (byte[])this.preprocessingBinarizeAdvancedWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> preprocessingBinarizeAdvancedWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingBinarizeAdvanced");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/binarize/advanced", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public GetPageAngleResult preprocessingGetPageAngle(Resource imageFile) throws RestClientException {
        return (GetPageAngleResult)this.preprocessingGetPageAngleWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<GetPageAngleResult> preprocessingGetPageAngleWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingGetPageAngle");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/get-page-angle", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<GetPageAngleResult> returnType = new ParameterizedTypeReference<GetPageAngleResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] preprocessingUnrotate(Resource imageFile) throws RestClientException {
        return (byte[])this.preprocessingUnrotateWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> preprocessingUnrotateWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingUnrotate");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/unrotate", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] preprocessingUnrotateAdvanced(Resource imageFile) throws RestClientException {
        return (byte[])this.preprocessingUnrotateAdvancedWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> preprocessingUnrotateAdvancedWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingUnrotateAdvanced");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/unrotate/advanced", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] preprocessingUnskew(Resource imageFile) throws RestClientException {
        return (byte[])this.preprocessingUnskewWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> preprocessingUnskewWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling preprocessingUnskew");
        }
        String path = this.apiClient.expandPath("/ocr/preprocessing/image/unskew", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

