/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.DrawPolygonRequest;
import com.cloudmersive.client.rt.model.DrawRectangleRequest;
import com.cloudmersive.client.rt.model.DrawTextRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.EditApi")
public class EditApi {
    private ApiClient apiClient;

    public EditApi() {
        this(new ApiClient());
    }

    @Autowired
    public EditApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] editAutoOrient(Resource imageFile) throws RestClientException {
        return (byte[])this.editAutoOrientWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> editAutoOrientWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editAutoOrient");
        }
        String path = this.apiClient.expandPath("/image/edit/auto-orient/remove-exif", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editCompositeBasic(String location, Resource baseImage, Resource layeredImage) throws RestClientException {
        return (byte[])this.editCompositeBasicWithHttpInfo(location, baseImage, layeredImage).getBody();
    }

    public ResponseEntity<byte[]> editCompositeBasicWithHttpInfo(String location, Resource baseImage, Resource layeredImage) throws RestClientException {
        Object postBody = null;
        if (location == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'location' when calling editCompositeBasic");
        }
        if (baseImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'baseImage' when calling editCompositeBasic");
        }
        if (layeredImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'layeredImage' when calling editCompositeBasic");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("location", location);
        String path = this.apiClient.expandPath("/image/edit/composite/{location}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (baseImage != null) {
            formParams.add((Object)"baseImage", (Object)baseImage);
        }
        if (layeredImage != null) {
            formParams.add((Object)"layeredImage", (Object)layeredImage);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editCompositePrecise(Resource baseImage, Resource layeredImage, Integer top, Integer bottom, Integer left, Integer right, Integer width, Integer height) throws RestClientException {
        return (byte[])this.editCompositePreciseWithHttpInfo(baseImage, layeredImage, top, bottom, left, right, width, height).getBody();
    }

    public ResponseEntity<byte[]> editCompositePreciseWithHttpInfo(Resource baseImage, Resource layeredImage, Integer top, Integer bottom, Integer left, Integer right, Integer width, Integer height) throws RestClientException {
        Object postBody = null;
        if (baseImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'baseImage' when calling editCompositePrecise");
        }
        if (layeredImage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'layeredImage' when calling editCompositePrecise");
        }
        String path = this.apiClient.expandPath("/image/edit/composite/precise", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (top != null) {
            headerParams.add("top", this.apiClient.parameterToString(top));
        }
        if (bottom != null) {
            headerParams.add("bottom", this.apiClient.parameterToString(bottom));
        }
        if (left != null) {
            headerParams.add("left", this.apiClient.parameterToString(left));
        }
        if (right != null) {
            headerParams.add("right", this.apiClient.parameterToString(right));
        }
        if (width != null) {
            headerParams.add("width", this.apiClient.parameterToString(width));
        }
        if (height != null) {
            headerParams.add("height", this.apiClient.parameterToString(height));
        }
        if (baseImage != null) {
            formParams.add((Object)"baseImage", (Object)baseImage);
        }
        if (layeredImage != null) {
            formParams.add((Object)"layeredImage", (Object)layeredImage);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editContrastAdaptive(Double gamma, Resource imageFile) throws RestClientException {
        return (byte[])this.editContrastAdaptiveWithHttpInfo(gamma, imageFile).getBody();
    }

    public ResponseEntity<byte[]> editContrastAdaptiveWithHttpInfo(Double gamma, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (gamma == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'gamma' when calling editContrastAdaptive");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editContrastAdaptive");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("gamma", gamma);
        String path = this.apiClient.expandPath("/image/edit/contrast/{gamma}/adaptive", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editCropCircle(Integer left, Integer top, Integer radius, Resource imageFile) throws RestClientException {
        return (byte[])this.editCropCircleWithHttpInfo(left, top, radius, imageFile).getBody();
    }

    public ResponseEntity<byte[]> editCropCircleWithHttpInfo(Integer left, Integer top, Integer radius, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (left == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'left' when calling editCropCircle");
        }
        if (top == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'top' when calling editCropCircle");
        }
        if (radius == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'radius' when calling editCropCircle");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editCropCircle");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("left", left);
        uriVariables.put("top", top);
        uriVariables.put("radius", radius);
        String path = this.apiClient.expandPath("/image/edit/crop/circle/{left}/{top}/{radius}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editCropRectangle(Integer left, Integer top, Integer width, Integer height, Resource imageFile) throws RestClientException {
        return (byte[])this.editCropRectangleWithHttpInfo(left, top, width, height, imageFile).getBody();
    }

    public ResponseEntity<byte[]> editCropRectangleWithHttpInfo(Integer left, Integer top, Integer width, Integer height, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (left == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'left' when calling editCropRectangle");
        }
        if (top == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'top' when calling editCropRectangle");
        }
        if (width == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'width' when calling editCropRectangle");
        }
        if (height == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'height' when calling editCropRectangle");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editCropRectangle");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("left", left);
        uriVariables.put("top", top);
        uriVariables.put("width", width);
        uriVariables.put("height", height);
        String path = this.apiClient.expandPath("/image/edit/crop/rectangle/{left}/{top}/{width}/{height}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editDrawPolygon(DrawPolygonRequest request) throws RestClientException {
        return (byte[])this.editDrawPolygonWithHttpInfo(request).getBody();
    }

    public ResponseEntity<byte[]> editDrawPolygonWithHttpInfo(DrawPolygonRequest request) throws RestClientException {
        DrawPolygonRequest postBody = request;
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'request' when calling editDrawPolygon");
        }
        String path = this.apiClient.expandPath("/image/edit/draw/polygon", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editDrawRectangle(DrawRectangleRequest request) throws RestClientException {
        return (byte[])this.editDrawRectangleWithHttpInfo(request).getBody();
    }

    public ResponseEntity<byte[]> editDrawRectangleWithHttpInfo(DrawRectangleRequest request) throws RestClientException {
        DrawRectangleRequest postBody = request;
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'request' when calling editDrawRectangle");
        }
        String path = this.apiClient.expandPath("/image/edit/draw/rectangle", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editDrawText(DrawTextRequest request) throws RestClientException {
        return (byte[])this.editDrawTextWithHttpInfo(request).getBody();
    }

    public ResponseEntity<byte[]> editDrawTextWithHttpInfo(DrawTextRequest request) throws RestClientException {
        DrawTextRequest postBody = request;
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'request' when calling editDrawText");
        }
        String path = this.apiClient.expandPath("/image/edit/draw/text", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editDropShadow(Integer X, Integer Y, Integer sigma, Integer opacity, Resource imageFile) throws RestClientException {
        return (byte[])this.editDropShadowWithHttpInfo(X, Y, sigma, opacity, imageFile).getBody();
    }

    public ResponseEntity<byte[]> editDropShadowWithHttpInfo(Integer X, Integer Y, Integer sigma, Integer opacity, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (X == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'X' when calling editDropShadow");
        }
        if (Y == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'Y' when calling editDropShadow");
        }
        if (sigma == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sigma' when calling editDropShadow");
        }
        if (opacity == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'opacity' when calling editDropShadow");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editDropShadow");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("X", X);
        uriVariables.put("Y", Y);
        uriVariables.put("sigma", sigma);
        uriVariables.put("opacity", opacity);
        String path = this.apiClient.expandPath("/image/edit/drop-shadow/{X}/{Y}/{sigma}/{opacity}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editInvert(Resource imageFile) throws RestClientException {
        return (byte[])this.editInvertWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> editInvertWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editInvert");
        }
        String path = this.apiClient.expandPath("/image/edit/invert", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editRemoveExifData(Resource imageFile) throws RestClientException {
        return (byte[])this.editRemoveExifDataWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> editRemoveExifDataWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editRemoveExifData");
        }
        String path = this.apiClient.expandPath("/image/edit/remove-exif", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editRemoveTransparency(Resource imageFile) throws RestClientException {
        return (byte[])this.editRemoveTransparencyWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> editRemoveTransparencyWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editRemoveTransparency");
        }
        String path = this.apiClient.expandPath("/image/edit/remove-transparency", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editRotate(Double degrees, Resource imageFile) throws RestClientException {
        return (byte[])this.editRotateWithHttpInfo(degrees, imageFile).getBody();
    }

    public ResponseEntity<byte[]> editRotateWithHttpInfo(Double degrees, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (degrees == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'degrees' when calling editRotate");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling editRotate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("degrees", degrees);
        String path = this.apiClient.expandPath("/image/edit/rotate/{degrees}/angle", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

