/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.GetImageInfoResult;
import com.cloudmersive.client.rt.model.MultipageImageFormatConversionResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.ConvertImageApi")
public class ConvertImageApi {
    private ApiClient apiClient;

    public ConvertImageApi() {
        this(new ApiClient());
    }

    @Autowired
    public ConvertImageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GetImageInfoResult convertImageGetImageInfo(Resource inputFile) throws RestClientException {
        return (GetImageInfoResult)this.convertImageGetImageInfoWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<GetImageInfoResult> convertImageGetImageInfoWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling convertImageGetImageInfo");
        }
        String path = this.apiClient.expandPath("/convert/image/get-info", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<GetImageInfoResult> returnType = new ParameterizedTypeReference<GetImageInfoResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] convertImageImageFormatConvert(String format1, String format2, Resource inputFile) throws RestClientException {
        return (byte[])this.convertImageImageFormatConvertWithHttpInfo(format1, format2, inputFile).getBody();
    }

    public ResponseEntity<byte[]> convertImageImageFormatConvertWithHttpInfo(String format1, String format2, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (format1 == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'format1' when calling convertImageImageFormatConvert");
        }
        if (format2 == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'format2' when calling convertImageImageFormatConvert");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling convertImageImageFormatConvert");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("format1", format1);
        uriVariables.put("format2", format2);
        String path = this.apiClient.expandPath("/convert/image/{format1}/to/{format2}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] convertImageImageSetDPI(Integer dpi, Resource inputFile) throws RestClientException {
        return (byte[])this.convertImageImageSetDPIWithHttpInfo(dpi, inputFile).getBody();
    }

    public ResponseEntity<byte[]> convertImageImageSetDPIWithHttpInfo(Integer dpi, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (dpi == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'dpi' when calling convertImageImageSetDPI");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling convertImageImageSetDPI");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("dpi", dpi);
        String path = this.apiClient.expandPath("/convert/image/set-dpi/{dpi}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public MultipageImageFormatConversionResult convertImageMultipageImageFormatConvert(String format1, String format2, Resource inputFile) throws RestClientException {
        return (MultipageImageFormatConversionResult)this.convertImageMultipageImageFormatConvertWithHttpInfo(format1, format2, inputFile).getBody();
    }

    public ResponseEntity<MultipageImageFormatConversionResult> convertImageMultipageImageFormatConvertWithHttpInfo(String format1, String format2, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (format1 == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'format1' when calling convertImageMultipageImageFormatConvert");
        }
        if (format2 == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'format2' when calling convertImageMultipageImageFormatConvert");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling convertImageMultipageImageFormatConvert");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("format1", format1);
        uriVariables.put("format2", format2);
        String path = this.apiClient.expandPath("/convert/image-multipage/{format1}/to/{format2}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<MultipageImageFormatConversionResult> returnType = new ParameterizedTypeReference<MultipageImageFormatConversionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

