/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.AudioApi")
public class AudioApi {
    private ApiClient apiClient;

    public AudioApi() {
        this(new ApiClient());
    }

    @Autowired
    public AudioApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] audioConvertToAac(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        return (byte[])this.audioConvertToAacWithHttpInfo(fileUrl, bitRate, inputFile).getBody();
    }

    public ResponseEntity<byte[]> audioConvertToAacWithHttpInfo(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/aac", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (bitRate != null) {
            headerParams.add("bitRate", this.apiClient.parameterToString(bitRate));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] audioConvertToM4a(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        return (byte[])this.audioConvertToM4aWithHttpInfo(fileUrl, bitRate, inputFile).getBody();
    }

    public ResponseEntity<byte[]> audioConvertToM4aWithHttpInfo(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/m4a", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (bitRate != null) {
            headerParams.add("bitRate", this.apiClient.parameterToString(bitRate));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] audioConvertToMp3(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        return (byte[])this.audioConvertToMp3WithHttpInfo(fileUrl, bitRate, inputFile).getBody();
    }

    public ResponseEntity<byte[]> audioConvertToMp3WithHttpInfo(String fileUrl, Integer bitRate, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/mp3", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (bitRate != null) {
            headerParams.add("bitRate", this.apiClient.parameterToString(bitRate));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] audioConvertToWav(String fileUrl, BigDecimal sampleRate, Resource inputFile) throws RestClientException {
        return (byte[])this.audioConvertToWavWithHttpInfo(fileUrl, sampleRate, inputFile).getBody();
    }

    public ResponseEntity<byte[]> audioConvertToWavWithHttpInfo(String fileUrl, BigDecimal sampleRate, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/wav", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (sampleRate != null) {
            headerParams.add("sampleRate", this.apiClient.parameterToString(sampleRate));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

