/*
 * configapi
 * Config API lets you easily manage configuration at scale.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.threeten.bp.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Value of a setting
 */
@ApiModel(description = "Value of a setting")
@JsonPropertyOrder({
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_VALUE_I_D,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_DEFINITION_I_D,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_VALUE,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_LAST_MODIFIED,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_NAME,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_DESCRIPTION,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_TAGS,
  SettingValue.JSON_PROPERTY_CONFIG_SETTING_TYPE
})
@JsonTypeName("SettingValue")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:26.703-08:00[America/Los_Angeles]")
public class SettingValue {
  public static final String JSON_PROPERTY_CONFIG_SETTING_VALUE_I_D = "ConfigSettingValueID";
  private String configSettingValueID;

  public static final String JSON_PROPERTY_CONFIG_SETTING_DEFINITION_I_D = "ConfigSettingDefinitionID";
  private String configSettingDefinitionID;

  public static final String JSON_PROPERTY_CONFIG_SETTING_VALUE = "ConfigSettingValue";
  private Object configSettingValue;

  public static final String JSON_PROPERTY_CONFIG_SETTING_LAST_MODIFIED = "ConfigSettingLastModified";
  private OffsetDateTime configSettingLastModified;

  public static final String JSON_PROPERTY_CONFIG_SETTING_NAME = "ConfigSettingName";
  private String configSettingName;

  public static final String JSON_PROPERTY_CONFIG_SETTING_DESCRIPTION = "ConfigSettingDescription";
  private String configSettingDescription;

  public static final String JSON_PROPERTY_CONFIG_SETTING_TAGS = "ConfigSettingTags";
  private String configSettingTags;

  public static final String JSON_PROPERTY_CONFIG_SETTING_TYPE = "ConfigSettingType";
  private String configSettingType;


  public SettingValue configSettingValueID(String configSettingValueID) {
    
    this.configSettingValueID = configSettingValueID;
    return this;
  }

   /**
   * The ID of the setting value
   * @return configSettingValueID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The ID of the setting value")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_VALUE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingValueID() {
    return configSettingValueID;
  }


  public void setConfigSettingValueID(String configSettingValueID) {
    this.configSettingValueID = configSettingValueID;
  }


  public SettingValue configSettingDefinitionID(String configSettingDefinitionID) {
    
    this.configSettingDefinitionID = configSettingDefinitionID;
    return this;
  }

   /**
   * The ID of the definition of the setting
   * @return configSettingDefinitionID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The ID of the definition of the setting")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_DEFINITION_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingDefinitionID() {
    return configSettingDefinitionID;
  }


  public void setConfigSettingDefinitionID(String configSettingDefinitionID) {
    this.configSettingDefinitionID = configSettingDefinitionID;
  }


  public SettingValue configSettingValue(Object configSettingValue) {
    
    this.configSettingValue = configSettingValue;
    return this;
  }

   /**
   * The value of the setting
   * @return configSettingValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The value of the setting")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getConfigSettingValue() {
    return configSettingValue;
  }


  public void setConfigSettingValue(Object configSettingValue) {
    this.configSettingValue = configSettingValue;
  }


  public SettingValue configSettingLastModified(OffsetDateTime configSettingLastModified) {
    
    this.configSettingLastModified = configSettingLastModified;
    return this;
  }

   /**
   * The last modified date of the setting
   * @return configSettingLastModified
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The last modified date of the setting")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getConfigSettingLastModified() {
    return configSettingLastModified;
  }


  public void setConfigSettingLastModified(OffsetDateTime configSettingLastModified) {
    this.configSettingLastModified = configSettingLastModified;
  }


  public SettingValue configSettingName(String configSettingName) {
    
    this.configSettingName = configSettingName;
    return this;
  }

   /**
   * Name of the setting
   * @return configSettingName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the setting")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingName() {
    return configSettingName;
  }


  public void setConfigSettingName(String configSettingName) {
    this.configSettingName = configSettingName;
  }


  public SettingValue configSettingDescription(String configSettingDescription) {
    
    this.configSettingDescription = configSettingDescription;
    return this;
  }

   /**
   * Description of the setting
   * @return configSettingDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Description of the setting")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingDescription() {
    return configSettingDescription;
  }


  public void setConfigSettingDescription(String configSettingDescription) {
    this.configSettingDescription = configSettingDescription;
  }


  public SettingValue configSettingTags(String configSettingTags) {
    
    this.configSettingTags = configSettingTags;
    return this;
  }

   /**
   * Setting tags
   * @return configSettingTags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Setting tags")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingTags() {
    return configSettingTags;
  }


  public void setConfigSettingTags(String configSettingTags) {
    this.configSettingTags = configSettingTags;
  }


  public SettingValue configSettingType(String configSettingType) {
    
    this.configSettingType = configSettingType;
    return this;
  }

   /**
   * Possible values are: STRING, JSON
   * @return configSettingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Possible values are: STRING, JSON")
  @JsonProperty(JSON_PROPERTY_CONFIG_SETTING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfigSettingType() {
    return configSettingType;
  }


  public void setConfigSettingType(String configSettingType) {
    this.configSettingType = configSettingType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SettingValue settingValue = (SettingValue) o;
    return Objects.equals(this.configSettingValueID, settingValue.configSettingValueID) &&
        Objects.equals(this.configSettingDefinitionID, settingValue.configSettingDefinitionID) &&
        Objects.equals(this.configSettingValue, settingValue.configSettingValue) &&
        Objects.equals(this.configSettingLastModified, settingValue.configSettingLastModified) &&
        Objects.equals(this.configSettingName, settingValue.configSettingName) &&
        Objects.equals(this.configSettingDescription, settingValue.configSettingDescription) &&
        Objects.equals(this.configSettingTags, settingValue.configSettingTags) &&
        Objects.equals(this.configSettingType, settingValue.configSettingType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configSettingValueID, configSettingDefinitionID, configSettingValue, configSettingLastModified, configSettingName, configSettingDescription, configSettingTags, configSettingType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SettingValue {\n");
    sb.append("    configSettingValueID: ").append(toIndentedString(configSettingValueID)).append("\n");
    sb.append("    configSettingDefinitionID: ").append(toIndentedString(configSettingDefinitionID)).append("\n");
    sb.append("    configSettingValue: ").append(toIndentedString(configSettingValue)).append("\n");
    sb.append("    configSettingLastModified: ").append(toIndentedString(configSettingLastModified)).append("\n");
    sb.append("    configSettingName: ").append(toIndentedString(configSettingName)).append("\n");
    sb.append("    configSettingDescription: ").append(toIndentedString(configSettingDescription)).append("\n");
    sb.append("    configSettingTags: ").append(toIndentedString(configSettingTags)).append("\n");
    sb.append("    configSettingType: ").append(toIndentedString(configSettingType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

