/*
 * nlpapiv2
 * The powerful Natural Language Processing APIs (v2) let you perform part of speech tagging, entity identification, sentence parsing, and much more to help you understand the meaning of unstructured text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.RephrasedSentenceOption;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * One input sentence and associated rephrasing results
 */
@ApiModel(description = "One input sentence and associated rephrasing results")
@JsonPropertyOrder({
  RephrasedSentence.JSON_PROPERTY_SENTENCE_INDEX,
  RephrasedSentence.JSON_PROPERTY_ORIGINAL_SENTENCE_TEXT,
  RephrasedSentence.JSON_PROPERTY_REPHRASINGS
})
@JsonTypeName("RephrasedSentence")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:09.229-08:00[America/Los_Angeles]")
public class RephrasedSentence {
  public static final String JSON_PROPERTY_SENTENCE_INDEX = "SentenceIndex";
  private Integer sentenceIndex;

  public static final String JSON_PROPERTY_ORIGINAL_SENTENCE_TEXT = "OriginalSentenceText";
  private String originalSentenceText;

  public static final String JSON_PROPERTY_REPHRASINGS = "Rephrasings";
  private List<RephrasedSentenceOption> rephrasings = null;


  public RephrasedSentence sentenceIndex(Integer sentenceIndex) {
    
    this.sentenceIndex = sentenceIndex;
    return this;
  }

   /**
   * Index of the sentence, 1-based, ordered
   * @return sentenceIndex
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Index of the sentence, 1-based, ordered")
  @JsonProperty(JSON_PROPERTY_SENTENCE_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSentenceIndex() {
    return sentenceIndex;
  }


  public void setSentenceIndex(Integer sentenceIndex) {
    this.sentenceIndex = sentenceIndex;
  }


  public RephrasedSentence originalSentenceText(String originalSentenceText) {
    
    this.originalSentenceText = originalSentenceText;
    return this;
  }

   /**
   * Original input sentence text
   * @return originalSentenceText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Original input sentence text")
  @JsonProperty(JSON_PROPERTY_ORIGINAL_SENTENCE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOriginalSentenceText() {
    return originalSentenceText;
  }


  public void setOriginalSentenceText(String originalSentenceText) {
    this.originalSentenceText = originalSentenceText;
  }


  public RephrasedSentence rephrasings(List<RephrasedSentenceOption> rephrasings) {
    
    this.rephrasings = rephrasings;
    return this;
  }

  public RephrasedSentence addRephrasingsItem(RephrasedSentenceOption rephrasingsItem) {
    if (this.rephrasings == null) {
      this.rephrasings = new ArrayList<RephrasedSentenceOption>();
    }
    this.rephrasings.add(rephrasingsItem);
    return this;
  }

   /**
   * Rephrasing text options, candidates of the original input sentence, in order - with best candidate first
   * @return rephrasings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rephrasing text options, candidates of the original input sentence, in order - with best candidate first")
  @JsonProperty(JSON_PROPERTY_REPHRASINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RephrasedSentenceOption> getRephrasings() {
    return rephrasings;
  }


  public void setRephrasings(List<RephrasedSentenceOption> rephrasings) {
    this.rephrasings = rephrasings;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RephrasedSentence rephrasedSentence = (RephrasedSentence) o;
    return Objects.equals(this.sentenceIndex, rephrasedSentence.sentenceIndex) &&
        Objects.equals(this.originalSentenceText, rephrasedSentence.originalSentenceText) &&
        Objects.equals(this.rephrasings, rephrasedSentence.rephrasings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sentenceIndex, originalSentenceText, rephrasings);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RephrasedSentence {\n");
    sb.append("    sentenceIndex: ").append(toIndentedString(sentenceIndex)).append("\n");
    sb.append("    originalSentenceText: ").append(toIndentedString(originalSentenceText)).append("\n");
    sb.append("    rephrasings: ").append(toIndentedString(rephrasings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

