/*
 * nlpapiv2
 * The powerful Natural Language Processing APIs (v2) let you perform part of speech tagging, entity identification, sentence parsing, and much more to help you understand the meaning of unstructured text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Output of a profanity analysis operation
 */
@ApiModel(description = "Output of a profanity analysis operation")
@JsonPropertyOrder({
  ProfanityAnalysisResponse.JSON_PROPERTY_SUCCESSFUL,
  ProfanityAnalysisResponse.JSON_PROPERTY_PROFANITY_SCORE_RESULT,
  ProfanityAnalysisResponse.JSON_PROPERTY_SENTENCE_COUNT
})
@JsonTypeName("ProfanityAnalysisResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:09.229-08:00[America/Los_Angeles]")
public class ProfanityAnalysisResponse {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_PROFANITY_SCORE_RESULT = "ProfanityScoreResult";
  private Double profanityScoreResult;

  public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
  private Integer sentenceCount;


  public ProfanityAnalysisResponse successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the profanity detection operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the profanity detection operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public ProfanityAnalysisResponse profanityScoreResult(Double profanityScoreResult) {
    
    this.profanityScoreResult = profanityScoreResult;
    return this;
  }

   /**
   * Profanity classification score between 0.0 and 1.0 where scores closer to zero have a low probability of being profane or contain obscene language, while scores close to 1.0 have a high probability of being profane or containing obscene language.  Values above 0.8 have a very high probability of being profane.
   * @return profanityScoreResult
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Profanity classification score between 0.0 and 1.0 where scores closer to zero have a low probability of being profane or contain obscene language, while scores close to 1.0 have a high probability of being profane or containing obscene language.  Values above 0.8 have a very high probability of being profane.")
  @JsonProperty(JSON_PROPERTY_PROFANITY_SCORE_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getProfanityScoreResult() {
    return profanityScoreResult;
  }


  public void setProfanityScoreResult(Double profanityScoreResult) {
    this.profanityScoreResult = profanityScoreResult;
  }


  public ProfanityAnalysisResponse sentenceCount(Integer sentenceCount) {
    
    this.sentenceCount = sentenceCount;
    return this;
  }

   /**
   * Number of sentences in input text
   * @return sentenceCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of sentences in input text")
  @JsonProperty(JSON_PROPERTY_SENTENCE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSentenceCount() {
    return sentenceCount;
  }


  public void setSentenceCount(Integer sentenceCount) {
    this.sentenceCount = sentenceCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProfanityAnalysisResponse profanityAnalysisResponse = (ProfanityAnalysisResponse) o;
    return Objects.equals(this.successful, profanityAnalysisResponse.successful) &&
        Objects.equals(this.profanityScoreResult, profanityAnalysisResponse.profanityScoreResult) &&
        Objects.equals(this.sentenceCount, profanityAnalysisResponse.sentenceCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, profanityScoreResult, sentenceCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProfanityAnalysisResponse {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    profanityScoreResult: ").append(toIndentedString(profanityScoreResult)).append("\n");
    sb.append("    sentenceCount: ").append(toIndentedString(sentenceCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

