/*
 * convertapi
 * Convert API lets you effortlessly convert file formats and types.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.threeten.bp.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * PDF Annotation details
 */
@ApiModel(description = "PDF Annotation details")
@JsonPropertyOrder({
  PdfAnnotation.JSON_PROPERTY_TITLE,
  PdfAnnotation.JSON_PROPERTY_ANNOTATION_TYPE,
  PdfAnnotation.JSON_PROPERTY_PAGE_NUMBER,
  PdfAnnotation.JSON_PROPERTY_ANNOTATION_INDEX,
  PdfAnnotation.JSON_PROPERTY_SUBJECT,
  PdfAnnotation.JSON_PROPERTY_TEXT_CONTENTS,
  PdfAnnotation.JSON_PROPERTY_CREATION_DATE,
  PdfAnnotation.JSON_PROPERTY_MODIFIED_DATE,
  PdfAnnotation.JSON_PROPERTY_LEFT_X,
  PdfAnnotation.JSON_PROPERTY_TOP_Y,
  PdfAnnotation.JSON_PROPERTY_WIDTH,
  PdfAnnotation.JSON_PROPERTY_HEIGHT
})
@JsonTypeName("PdfAnnotation")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:19.979-08:00[America/Los_Angeles]")
public class PdfAnnotation {
  public static final String JSON_PROPERTY_TITLE = "Title";
  private String title;

  public static final String JSON_PROPERTY_ANNOTATION_TYPE = "AnnotationType";
  private String annotationType;

  public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
  private Integer pageNumber;

  public static final String JSON_PROPERTY_ANNOTATION_INDEX = "AnnotationIndex";
  private Integer annotationIndex;

  public static final String JSON_PROPERTY_SUBJECT = "Subject";
  private String subject;

  public static final String JSON_PROPERTY_TEXT_CONTENTS = "TextContents";
  private String textContents;

  public static final String JSON_PROPERTY_CREATION_DATE = "CreationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_MODIFIED_DATE = "ModifiedDate";
  private OffsetDateTime modifiedDate;

  public static final String JSON_PROPERTY_LEFT_X = "LeftX";
  private Double leftX;

  public static final String JSON_PROPERTY_TOP_Y = "TopY";
  private Double topY;

  public static final String JSON_PROPERTY_WIDTH = "Width";
  private Double width;

  public static final String JSON_PROPERTY_HEIGHT = "Height";
  private Double height;


  public PdfAnnotation title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * Title of the annotation; this is often the author of the annotation in Acrobat-created PDF files
   * @return title
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Title of the annotation; this is often the author of the annotation in Acrobat-created PDF files")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  public PdfAnnotation annotationType(String annotationType) {
    
    this.annotationType = annotationType;
    return this;
  }

   /**
   * Type of the annotation; possible values are Text
   * @return annotationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of the annotation; possible values are Text")
  @JsonProperty(JSON_PROPERTY_ANNOTATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAnnotationType() {
    return annotationType;
  }


  public void setAnnotationType(String annotationType) {
    this.annotationType = annotationType;
  }


  public PdfAnnotation pageNumber(Integer pageNumber) {
    
    this.pageNumber = pageNumber;
    return this;
  }

   /**
   * The 1-based index of the page containing the annotation
   * @return pageNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The 1-based index of the page containing the annotation")
  @JsonProperty(JSON_PROPERTY_PAGE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPageNumber() {
    return pageNumber;
  }


  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }


  public PdfAnnotation annotationIndex(Integer annotationIndex) {
    
    this.annotationIndex = annotationIndex;
    return this;
  }

   /**
   * The 0-based index of the annotation in the document
   * @return annotationIndex
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The 0-based index of the annotation in the document")
  @JsonProperty(JSON_PROPERTY_ANNOTATION_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnnotationIndex() {
    return annotationIndex;
  }


  public void setAnnotationIndex(Integer annotationIndex) {
    this.annotationIndex = annotationIndex;
  }


  public PdfAnnotation subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * Subject of the annotation
   * @return subject
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Subject of the annotation")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  public void setSubject(String subject) {
    this.subject = subject;
  }


  public PdfAnnotation textContents(String textContents) {
    
    this.textContents = textContents;
    return this;
  }

   /**
   * Text contents of the annotation
   * @return textContents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Text contents of the annotation")
  @JsonProperty(JSON_PROPERTY_TEXT_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTextContents() {
    return textContents;
  }


  public void setTextContents(String textContents) {
    this.textContents = textContents;
  }


  public PdfAnnotation creationDate(OffsetDateTime creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * Date that the annotation was created
   * @return creationDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Date that the annotation was created")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public PdfAnnotation modifiedDate(OffsetDateTime modifiedDate) {
    
    this.modifiedDate = modifiedDate;
    return this;
  }

   /**
   * Date that the annotation was last modified
   * @return modifiedDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Date that the annotation was last modified")
  @JsonProperty(JSON_PROPERTY_MODIFIED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getModifiedDate() {
    return modifiedDate;
  }


  public void setModifiedDate(OffsetDateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
  }


  public PdfAnnotation leftX(Double leftX) {
    
    this.leftX = leftX;
    return this;
  }

   /**
   * Left X coordinate for the location of the annotation
   * @return leftX
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Left X coordinate for the location of the annotation")
  @JsonProperty(JSON_PROPERTY_LEFT_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLeftX() {
    return leftX;
  }


  public void setLeftX(Double leftX) {
    this.leftX = leftX;
  }


  public PdfAnnotation topY(Double topY) {
    
    this.topY = topY;
    return this;
  }

   /**
   * Top Y coordination of the location of the annotation
   * @return topY
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Top Y coordination of the location of the annotation")
  @JsonProperty(JSON_PROPERTY_TOP_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getTopY() {
    return topY;
  }


  public void setTopY(Double topY) {
    this.topY = topY;
  }


  public PdfAnnotation width(Double width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width of the annotation
   * @return width
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Width of the annotation")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getWidth() {
    return width;
  }


  public void setWidth(Double width) {
    this.width = width;
  }


  public PdfAnnotation height(Double height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height of the annotation
   * @return height
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Height of the annotation")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getHeight() {
    return height;
  }


  public void setHeight(Double height) {
    this.height = height;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PdfAnnotation pdfAnnotation = (PdfAnnotation) o;
    return Objects.equals(this.title, pdfAnnotation.title) &&
        Objects.equals(this.annotationType, pdfAnnotation.annotationType) &&
        Objects.equals(this.pageNumber, pdfAnnotation.pageNumber) &&
        Objects.equals(this.annotationIndex, pdfAnnotation.annotationIndex) &&
        Objects.equals(this.subject, pdfAnnotation.subject) &&
        Objects.equals(this.textContents, pdfAnnotation.textContents) &&
        Objects.equals(this.creationDate, pdfAnnotation.creationDate) &&
        Objects.equals(this.modifiedDate, pdfAnnotation.modifiedDate) &&
        Objects.equals(this.leftX, pdfAnnotation.leftX) &&
        Objects.equals(this.topY, pdfAnnotation.topY) &&
        Objects.equals(this.width, pdfAnnotation.width) &&
        Objects.equals(this.height, pdfAnnotation.height);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, annotationType, pageNumber, annotationIndex, subject, textContents, creationDate, modifiedDate, leftX, topY, width, height);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PdfAnnotation {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    annotationType: ").append(toIndentedString(annotationType)).append("\n");
    sb.append("    pageNumber: ").append(toIndentedString(pageNumber)).append("\n");
    sb.append("    annotationIndex: ").append(toIndentedString(annotationIndex)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    textContents: ").append(toIndentedString(textContents)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    modifiedDate: ").append(toIndentedString(modifiedDate)).append("\n");
    sb.append("    leftX: ").append(toIndentedString(leftX)).append("\n");
    sb.append("    topY: ").append(toIndentedString(topY)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

