/*
 * ocrapi
 * The powerful Optical Character Recognition (OCR) APIs let you convert scanned images of pages into recognized text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.Point;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * A single text in an OCR document
 */
@ApiModel(description = "A single text in an OCR document")
@JsonPropertyOrder({
  OcrPhotoTextElement.JSON_PROPERTY_TEXT,
  OcrPhotoTextElement.JSON_PROPERTY_XLEFT,
  OcrPhotoTextElement.JSON_PROPERTY_YTOP,
  OcrPhotoTextElement.JSON_PROPERTY_WIDTH,
  OcrPhotoTextElement.JSON_PROPERTY_HEIGHT,
  OcrPhotoTextElement.JSON_PROPERTY_BOUNDING_POINTS,
  OcrPhotoTextElement.JSON_PROPERTY_CONFIDENCE_LEVEL
})
@JsonTypeName("OcrPhotoTextElement")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:12.411-08:00[America/Los_Angeles]")
public class OcrPhotoTextElement {
  public static final String JSON_PROPERTY_TEXT = "Text";
  private String text;

  public static final String JSON_PROPERTY_XLEFT = "XLeft";
  private Integer xleft;

  public static final String JSON_PROPERTY_YTOP = "YTop";
  private Integer ytop;

  public static final String JSON_PROPERTY_WIDTH = "Width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "Height";
  private Integer height;

  public static final String JSON_PROPERTY_BOUNDING_POINTS = "BoundingPoints";
  private List<Point> boundingPoints = null;

  public static final String JSON_PROPERTY_CONFIDENCE_LEVEL = "ConfidenceLevel";
  private Double confidenceLevel;


  public OcrPhotoTextElement text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Text of the word
   * @return text
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Text of the word")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  public void setText(String text) {
    this.text = text;
  }


  public OcrPhotoTextElement xleft(Integer xleft) {
    
    this.xleft = xleft;
    return this;
  }

   /**
   * X location of the left edge of the word in pixels
   * @return xleft
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "X location of the left edge of the word in pixels")
  @JsonProperty(JSON_PROPERTY_XLEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getXleft() {
    return xleft;
  }


  public void setXleft(Integer xleft) {
    this.xleft = xleft;
  }


  public OcrPhotoTextElement ytop(Integer ytop) {
    
    this.ytop = ytop;
    return this;
  }

   /**
   * Y location of the top edge of the word in pixels
   * @return ytop
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Y location of the top edge of the word in pixels")
  @JsonProperty(JSON_PROPERTY_YTOP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getYtop() {
    return ytop;
  }


  public void setYtop(Integer ytop) {
    this.ytop = ytop;
  }


  public OcrPhotoTextElement width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width of the word in pixels
   * @return width
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Width of the word in pixels")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  public void setWidth(Integer width) {
    this.width = width;
  }


  public OcrPhotoTextElement height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height of the word in pixels
   * @return height
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Height of the word in pixels")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  public void setHeight(Integer height) {
    this.height = height;
  }


  public OcrPhotoTextElement boundingPoints(List<Point> boundingPoints) {
    
    this.boundingPoints = boundingPoints;
    return this;
  }

  public OcrPhotoTextElement addBoundingPointsItem(Point boundingPointsItem) {
    if (this.boundingPoints == null) {
      this.boundingPoints = new ArrayList<Point>();
    }
    this.boundingPoints.add(boundingPointsItem);
    return this;
  }

   /**
   * Points that form the bounding polygon around the text
   * @return boundingPoints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Points that form the bounding polygon around the text")
  @JsonProperty(JSON_PROPERTY_BOUNDING_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Point> getBoundingPoints() {
    return boundingPoints;
  }


  public void setBoundingPoints(List<Point> boundingPoints) {
    this.boundingPoints = boundingPoints;
  }


  public OcrPhotoTextElement confidenceLevel(Double confidenceLevel) {
    
    this.confidenceLevel = confidenceLevel;
    return this;
  }

   /**
   * Confidence level of the machine learning result; possible values are 0.0 (lowest accuracy) - 1.0 (highest accuracy)
   * @return confidenceLevel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Confidence level of the machine learning result; possible values are 0.0 (lowest accuracy) - 1.0 (highest accuracy)")
  @JsonProperty(JSON_PROPERTY_CONFIDENCE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getConfidenceLevel() {
    return confidenceLevel;
  }


  public void setConfidenceLevel(Double confidenceLevel) {
    this.confidenceLevel = confidenceLevel;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OcrPhotoTextElement ocrPhotoTextElement = (OcrPhotoTextElement) o;
    return Objects.equals(this.text, ocrPhotoTextElement.text) &&
        Objects.equals(this.xleft, ocrPhotoTextElement.xleft) &&
        Objects.equals(this.ytop, ocrPhotoTextElement.ytop) &&
        Objects.equals(this.width, ocrPhotoTextElement.width) &&
        Objects.equals(this.height, ocrPhotoTextElement.height) &&
        Objects.equals(this.boundingPoints, ocrPhotoTextElement.boundingPoints) &&
        Objects.equals(this.confidenceLevel, ocrPhotoTextElement.confidenceLevel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, xleft, ytop, width, height, boundingPoints, confidenceLevel);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OcrPhotoTextElement {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    xleft: ").append(toIndentedString(xleft)).append("\n");
    sb.append("    ytop: ").append(toIndentedString(ytop)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    boundingPoints: ").append(toIndentedString(boundingPoints)).append("\n");
    sb.append("    confidenceLevel: ").append(toIndentedString(confidenceLevel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

