/*
 * ocrapi
 * The powerful Optical Character Recognition (OCR) APIs let you convert scanned images of pages into recognized text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.OcrWordElement;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * A contiguous line of text in an OCR document
 */
@ApiModel(description = "A contiguous line of text in an OCR document")
@JsonPropertyOrder({
  OcrLineElement.JSON_PROPERTY_LINE_TEXT,
  OcrLineElement.JSON_PROPERTY_WORDS
})
@JsonTypeName("OcrLineElement")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:12.411-08:00[America/Los_Angeles]")
public class OcrLineElement {
  public static final String JSON_PROPERTY_LINE_TEXT = "LineText";
  private String lineText;

  public static final String JSON_PROPERTY_WORDS = "Words";
  private List<OcrWordElement> words = null;


  public OcrLineElement lineText(String lineText) {
    
    this.lineText = lineText;
    return this;
  }

   /**
   * Text of the line
   * @return lineText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Text of the line")
  @JsonProperty(JSON_PROPERTY_LINE_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLineText() {
    return lineText;
  }


  public void setLineText(String lineText) {
    this.lineText = lineText;
  }


  public OcrLineElement words(List<OcrWordElement> words) {
    
    this.words = words;
    return this;
  }

  public OcrLineElement addWordsItem(OcrWordElement wordsItem) {
    if (this.words == null) {
      this.words = new ArrayList<OcrWordElement>();
    }
    this.words.add(wordsItem);
    return this;
  }

   /**
   * Word objects in the line
   * @return words
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Word objects in the line")
  @JsonProperty(JSON_PROPERTY_WORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OcrWordElement> getWords() {
    return words;
  }


  public void setWords(List<OcrWordElement> words) {
    this.words = words;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OcrLineElement ocrLineElement = (OcrLineElement) o;
    return Objects.equals(this.lineText, ocrLineElement.lineText) &&
        Objects.equals(this.words, ocrLineElement.words);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineText, words);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OcrLineElement {\n");
    sb.append("    lineText: ").append(toIndentedString(lineText)).append("\n");
    sb.append("    words: ").append(toIndentedString(words)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

