/*
 * convertapi
 * Convert API lets you effortlessly convert file formats and types.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.DocxTableRow;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Input to a Insert Table Row request
 */
@ApiModel(description = "Input to a Insert Table Row request")
@JsonPropertyOrder({
  InsertDocxTableRowRequest.JSON_PROPERTY_INPUT_FILE_BYTES,
  InsertDocxTableRowRequest.JSON_PROPERTY_INPUT_FILE_URL,
  InsertDocxTableRowRequest.JSON_PROPERTY_ROW_TO_INSERT,
  InsertDocxTableRowRequest.JSON_PROPERTY_INSERT_PLACEMENT,
  InsertDocxTableRowRequest.JSON_PROPERTY_EXISTING_TABLE_PATH
})
@JsonTypeName("InsertDocxTableRowRequest")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:19.979-08:00[America/Los_Angeles]")
public class InsertDocxTableRowRequest {
  public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
  private byte[] inputFileBytes;

  public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
  private String inputFileUrl;

  public static final String JSON_PROPERTY_ROW_TO_INSERT = "RowToInsert";
  private DocxTableRow rowToInsert;

  public static final String JSON_PROPERTY_INSERT_PLACEMENT = "InsertPlacement";
  private String insertPlacement;

  public static final String JSON_PROPERTY_EXISTING_TABLE_PATH = "ExistingTablePath";
  private String existingTablePath;


  public InsertDocxTableRowRequest inputFileBytes(byte[] inputFileBytes) {
    
    this.inputFileBytes = inputFileBytes;
    return this;
  }

   /**
   * Optional: Bytes of the input file to operate on
   * @return inputFileBytes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional: Bytes of the input file to operate on")
  @JsonProperty(JSON_PROPERTY_INPUT_FILE_BYTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getInputFileBytes() {
    return inputFileBytes;
  }


  public void setInputFileBytes(byte[] inputFileBytes) {
    this.inputFileBytes = inputFileBytes;
  }


  public InsertDocxTableRowRequest inputFileUrl(String inputFileUrl) {
    
    this.inputFileUrl = inputFileUrl;
    return this;
  }

   /**
   * Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).
   * @return inputFileUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
  @JsonProperty(JSON_PROPERTY_INPUT_FILE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInputFileUrl() {
    return inputFileUrl;
  }


  public void setInputFileUrl(String inputFileUrl) {
    this.inputFileUrl = inputFileUrl;
  }


  public InsertDocxTableRowRequest rowToInsert(DocxTableRow rowToInsert) {
    
    this.rowToInsert = rowToInsert;
    return this;
  }

   /**
   * Get rowToInsert
   * @return rowToInsert
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROW_TO_INSERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocxTableRow getRowToInsert() {
    return rowToInsert;
  }


  public void setRowToInsert(DocxTableRow rowToInsert) {
    this.rowToInsert = rowToInsert;
  }


  public InsertDocxTableRowRequest insertPlacement(String insertPlacement) {
    
    this.insertPlacement = insertPlacement;
    return this;
  }

   /**
   * Optional; default is TableEnd.  Placement Type of the insert; possible values are: TableStart (very beginning of the table), TableEnd (very end of the document), or a 0-based row index number as an integer, 0 being the first row in the table, 1 being the second row in the table, 2 being the third row in the table, etc. to insert this row after
   * @return insertPlacement
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional; default is TableEnd.  Placement Type of the insert; possible values are: TableStart (very beginning of the table), TableEnd (very end of the document), or a 0-based row index number as an integer, 0 being the first row in the table, 1 being the second row in the table, 2 being the third row in the table, etc. to insert this row after")
  @JsonProperty(JSON_PROPERTY_INSERT_PLACEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInsertPlacement() {
    return insertPlacement;
  }


  public void setInsertPlacement(String insertPlacement) {
    this.insertPlacement = insertPlacement;
  }


  public InsertDocxTableRowRequest existingTablePath(String existingTablePath) {
    
    this.existingTablePath = existingTablePath;
    return this;
  }

   /**
   * Required; the path to the existing table to modify
   * @return existingTablePath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Required; the path to the existing table to modify")
  @JsonProperty(JSON_PROPERTY_EXISTING_TABLE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExistingTablePath() {
    return existingTablePath;
  }


  public void setExistingTablePath(String existingTablePath) {
    this.existingTablePath = existingTablePath;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InsertDocxTableRowRequest insertDocxTableRowRequest = (InsertDocxTableRowRequest) o;
    return Arrays.equals(this.inputFileBytes, insertDocxTableRowRequest.inputFileBytes) &&
        Objects.equals(this.inputFileUrl, insertDocxTableRowRequest.inputFileUrl) &&
        Objects.equals(this.rowToInsert, insertDocxTableRowRequest.rowToInsert) &&
        Objects.equals(this.insertPlacement, insertDocxTableRowRequest.insertPlacement) &&
        Objects.equals(this.existingTablePath, insertDocxTableRowRequest.existingTablePath);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(inputFileBytes), inputFileUrl, rowToInsert, insertPlacement, existingTablePath);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InsertDocxTableRowRequest {\n");
    sb.append("    inputFileBytes: ").append(toIndentedString(inputFileBytes)).append("\n");
    sb.append("    inputFileUrl: ").append(toIndentedString(inputFileUrl)).append("\n");
    sb.append("    rowToInsert: ").append(toIndentedString(rowToInsert)).append("\n");
    sb.append("    insertPlacement: ").append(toIndentedString(insertPlacement)).append("\n");
    sb.append("    existingTablePath: ").append(toIndentedString(existingTablePath)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

