/*
 * imageapi
 * Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.ImageMetadataExifValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Metadata from an image
 */
@ApiModel(description = "Metadata from an image")
@JsonPropertyOrder({
  ImageMetadata.JSON_PROPERTY_SUCCESSFUL,
  ImageMetadata.JSON_PROPERTY_IS_VALID_IMAGE,
  ImageMetadata.JSON_PROPERTY_FILE_FORMAT,
  ImageMetadata.JSON_PROPERTY_WIDTH,
  ImageMetadata.JSON_PROPERTY_HEIGHT,
  ImageMetadata.JSON_PROPERTY_BIT_DEPTH,
  ImageMetadata.JSON_PROPERTY_HAS_TRANSPARENCY,
  ImageMetadata.JSON_PROPERTY_COLOR_SPACE,
  ImageMetadata.JSON_PROPERTY_EXIF_PROFILE_NAME,
  ImageMetadata.JSON_PROPERTY_EXIF_VALUES
})
@JsonTypeName("ImageMetadata")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:16.765-08:00[America/Los_Angeles]")
public class ImageMetadata {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_IS_VALID_IMAGE = "IsValidImage";
  private Boolean isValidImage;

  public static final String JSON_PROPERTY_FILE_FORMAT = "FileFormat";
  private String fileFormat;

  public static final String JSON_PROPERTY_WIDTH = "Width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "Height";
  private Integer height;

  public static final String JSON_PROPERTY_BIT_DEPTH = "BitDepth";
  private Integer bitDepth;

  public static final String JSON_PROPERTY_HAS_TRANSPARENCY = "HasTransparency";
  private Boolean hasTransparency;

  public static final String JSON_PROPERTY_COLOR_SPACE = "ColorSpace";
  private String colorSpace;

  public static final String JSON_PROPERTY_EXIF_PROFILE_NAME = "ExifProfileName";
  private String exifProfileName;

  public static final String JSON_PROPERTY_EXIF_VALUES = "ExifValues";
  private List<ImageMetadataExifValue> exifValues = null;


  public ImageMetadata successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public ImageMetadata isValidImage(Boolean isValidImage) {
    
    this.isValidImage = isValidImage;
    return this;
  }

   /**
   * True if the input image is a valid image file, false otherwise
   * @return isValidImage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the input image is a valid image file, false otherwise")
  @JsonProperty(JSON_PROPERTY_IS_VALID_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsValidImage() {
    return isValidImage;
  }


  public void setIsValidImage(Boolean isValidImage) {
    this.isValidImage = isValidImage;
  }


  public ImageMetadata fileFormat(String fileFormat) {
    
    this.fileFormat = fileFormat;
    return this;
  }

   /**
   * File format of the image
   * @return fileFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "File format of the image")
  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileFormat() {
    return fileFormat;
  }


  public void setFileFormat(String fileFormat) {
    this.fileFormat = fileFormat;
  }


  public ImageMetadata width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width of the image in pixels
   * @return width
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Width of the image in pixels")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  public void setWidth(Integer width) {
    this.width = width;
  }


  public ImageMetadata height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height of the image in pixels
   * @return height
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Height of the image in pixels")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  public void setHeight(Integer height) {
    this.height = height;
  }


  public ImageMetadata bitDepth(Integer bitDepth) {
    
    this.bitDepth = bitDepth;
    return this;
  }

   /**
   * Bits per pixel
   * @return bitDepth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Bits per pixel")
  @JsonProperty(JSON_PROPERTY_BIT_DEPTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBitDepth() {
    return bitDepth;
  }


  public void setBitDepth(Integer bitDepth) {
    this.bitDepth = bitDepth;
  }


  public ImageMetadata hasTransparency(Boolean hasTransparency) {
    
    this.hasTransparency = hasTransparency;
    return this;
  }

   /**
   * True if the image has transaprency in the form of an alpha channel, false otherwise
   * @return hasTransparency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the image has transaprency in the form of an alpha channel, false otherwise")
  @JsonProperty(JSON_PROPERTY_HAS_TRANSPARENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasTransparency() {
    return hasTransparency;
  }


  public void setHasTransparency(Boolean hasTransparency) {
    this.hasTransparency = hasTransparency;
  }


  public ImageMetadata colorSpace(String colorSpace) {
    
    this.colorSpace = colorSpace;
    return this;
  }

   /**
   * Color space of the image
   * @return colorSpace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Color space of the image")
  @JsonProperty(JSON_PROPERTY_COLOR_SPACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColorSpace() {
    return colorSpace;
  }


  public void setColorSpace(String colorSpace) {
    this.colorSpace = colorSpace;
  }


  public ImageMetadata exifProfileName(String exifProfileName) {
    
    this.exifProfileName = exifProfileName;
    return this;
  }

   /**
   * Name of the EXIF profile used
   * @return exifProfileName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the EXIF profile used")
  @JsonProperty(JSON_PROPERTY_EXIF_PROFILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExifProfileName() {
    return exifProfileName;
  }


  public void setExifProfileName(String exifProfileName) {
    this.exifProfileName = exifProfileName;
  }


  public ImageMetadata exifValues(List<ImageMetadataExifValue> exifValues) {
    
    this.exifValues = exifValues;
    return this;
  }

  public ImageMetadata addExifValuesItem(ImageMetadataExifValue exifValuesItem) {
    if (this.exifValues == null) {
      this.exifValues = new ArrayList<ImageMetadataExifValue>();
    }
    this.exifValues.add(exifValuesItem);
    return this;
  }

   /**
   * EXIF tags and values embedded in the image
   * @return exifValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EXIF tags and values embedded in the image")
  @JsonProperty(JSON_PROPERTY_EXIF_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ImageMetadataExifValue> getExifValues() {
    return exifValues;
  }


  public void setExifValues(List<ImageMetadataExifValue> exifValues) {
    this.exifValues = exifValues;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageMetadata imageMetadata = (ImageMetadata) o;
    return Objects.equals(this.successful, imageMetadata.successful) &&
        Objects.equals(this.isValidImage, imageMetadata.isValidImage) &&
        Objects.equals(this.fileFormat, imageMetadata.fileFormat) &&
        Objects.equals(this.width, imageMetadata.width) &&
        Objects.equals(this.height, imageMetadata.height) &&
        Objects.equals(this.bitDepth, imageMetadata.bitDepth) &&
        Objects.equals(this.hasTransparency, imageMetadata.hasTransparency) &&
        Objects.equals(this.colorSpace, imageMetadata.colorSpace) &&
        Objects.equals(this.exifProfileName, imageMetadata.exifProfileName) &&
        Objects.equals(this.exifValues, imageMetadata.exifValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, isValidImage, fileFormat, width, height, bitDepth, hasTransparency, colorSpace, exifProfileName, exifValues);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageMetadata {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    isValidImage: ").append(toIndentedString(isValidImage)).append("\n");
    sb.append("    fileFormat: ").append(toIndentedString(fileFormat)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    bitDepth: ").append(toIndentedString(bitDepth)).append("\n");
    sb.append("    hasTransparency: ").append(toIndentedString(hasTransparency)).append("\n");
    sb.append("    colorSpace: ").append(toIndentedString(colorSpace)).append("\n");
    sb.append("    exifProfileName: ").append(toIndentedString(exifProfileName)).append("\n");
    sb.append("    exifValues: ").append(toIndentedString(exifValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

