/*
 * validateapi
 * The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Geolocation result
 */
@ApiModel(description = "Geolocation result")
@JsonPropertyOrder({
  GeolocateResponse.JSON_PROPERTY_COUNTRY_CODE,
  GeolocateResponse.JSON_PROPERTY_COUNTRY_NAME,
  GeolocateResponse.JSON_PROPERTY_CITY,
  GeolocateResponse.JSON_PROPERTY_REGION_CODE,
  GeolocateResponse.JSON_PROPERTY_REGION_NAME,
  GeolocateResponse.JSON_PROPERTY_ZIP_CODE,
  GeolocateResponse.JSON_PROPERTY_TIMEZONE_STANDARD_NAME,
  GeolocateResponse.JSON_PROPERTY_LATITUDE,
  GeolocateResponse.JSON_PROPERTY_LONGITUDE
})
@JsonTypeName("GeolocateResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:06.593-08:00[America/Los_Angeles]")
public class GeolocateResponse {
  public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
  private String countryName;

  public static final String JSON_PROPERTY_CITY = "City";
  private String city;

  public static final String JSON_PROPERTY_REGION_CODE = "RegionCode";
  private String regionCode;

  public static final String JSON_PROPERTY_REGION_NAME = "RegionName";
  private String regionName;

  public static final String JSON_PROPERTY_ZIP_CODE = "ZipCode";
  private String zipCode;

  public static final String JSON_PROPERTY_TIMEZONE_STANDARD_NAME = "TimezoneStandardName";
  private String timezoneStandardName;

  public static final String JSON_PROPERTY_LATITUDE = "Latitude";
  private Double latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "Longitude";
  private Double longitude;


  public GeolocateResponse countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Two-letter country code of IP address
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Two-letter country code of IP address")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public GeolocateResponse countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name of IP address
   * @return countryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Country name of IP address")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public GeolocateResponse city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City of IP address
   * @return city
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "City of IP address")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  public void setCity(String city) {
    this.city = city;
  }


  public GeolocateResponse regionCode(String regionCode) {
    
    this.regionCode = regionCode;
    return this;
  }

   /**
   * State/region code of IP address
   * @return regionCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "State/region code of IP address")
  @JsonProperty(JSON_PROPERTY_REGION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRegionCode() {
    return regionCode;
  }


  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }


  public GeolocateResponse regionName(String regionName) {
    
    this.regionName = regionName;
    return this;
  }

   /**
   * State/region of IP address
   * @return regionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "State/region of IP address")
  @JsonProperty(JSON_PROPERTY_REGION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRegionName() {
    return regionName;
  }


  public void setRegionName(String regionName) {
    this.regionName = regionName;
  }


  public GeolocateResponse zipCode(String zipCode) {
    
    this.zipCode = zipCode;
    return this;
  }

   /**
   * Zip or postal code of IP address
   * @return zipCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Zip or postal code of IP address")
  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getZipCode() {
    return zipCode;
  }


  public void setZipCode(String zipCode) {
    this.zipCode = zipCode;
  }


  public GeolocateResponse timezoneStandardName(String timezoneStandardName) {
    
    this.timezoneStandardName = timezoneStandardName;
    return this;
  }

   /**
   * Timezone of IP address
   * @return timezoneStandardName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timezone of IP address")
  @JsonProperty(JSON_PROPERTY_TIMEZONE_STANDARD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezoneStandardName() {
    return timezoneStandardName;
  }


  public void setTimezoneStandardName(String timezoneStandardName) {
    this.timezoneStandardName = timezoneStandardName;
  }


  public GeolocateResponse latitude(Double latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude of IP address
   * @return latitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Latitude of IP address")
  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLatitude() {
    return latitude;
  }


  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }


  public GeolocateResponse longitude(Double longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude of IP address
   * @return longitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Longitude of IP address")
  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLongitude() {
    return longitude;
  }


  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeolocateResponse geolocateResponse = (GeolocateResponse) o;
    return Objects.equals(this.countryCode, geolocateResponse.countryCode) &&
        Objects.equals(this.countryName, geolocateResponse.countryName) &&
        Objects.equals(this.city, geolocateResponse.city) &&
        Objects.equals(this.regionCode, geolocateResponse.regionCode) &&
        Objects.equals(this.regionName, geolocateResponse.regionName) &&
        Objects.equals(this.zipCode, geolocateResponse.zipCode) &&
        Objects.equals(this.timezoneStandardName, geolocateResponse.timezoneStandardName) &&
        Objects.equals(this.latitude, geolocateResponse.latitude) &&
        Objects.equals(this.longitude, geolocateResponse.longitude);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countryCode, countryName, city, regionCode, regionName, zipCode, timezoneStandardName, latitude, longitude);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeolocateResponse {\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    regionCode: ").append(toIndentedString(regionCode)).append("\n");
    sb.append("    regionName: ").append(toIndentedString(regionName)).append("\n");
    sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
    sb.append("    timezoneStandardName: ").append(toIndentedString(timezoneStandardName)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

