/*
 * ocrapi
 * The powerful Optical Character Recognition (OCR) APIs let you convert scanned images of pages into recognized text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Definition of a column within a table for OCR data extraction from images
 */
@ApiModel(description = "Definition of a column within a table for OCR data extraction from images")
@JsonPropertyOrder({
  FormTableColumnDefinition.JSON_PROPERTY_COLUMN_I_D,
  FormTableColumnDefinition.JSON_PROPERTY_TOP_ANCHOR,
  FormTableColumnDefinition.JSON_PROPERTY_ANCHOR_MODE,
  FormTableColumnDefinition.JSON_PROPERTY_DATA_TYPE,
  FormTableColumnDefinition.JSON_PROPERTY_MINIMUM_CHARACTER_COUNT,
  FormTableColumnDefinition.JSON_PROPERTY_ALLOW_NUMERIC_DIGITS
})
@JsonTypeName("FormTableColumnDefinition")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:12.411-08:00[America/Los_Angeles]")
public class FormTableColumnDefinition {
  public static final String JSON_PROPERTY_COLUMN_I_D = "ColumnID";
  private String columnID;

  public static final String JSON_PROPERTY_TOP_ANCHOR = "TopAnchor";
  private String topAnchor;

  public static final String JSON_PROPERTY_ANCHOR_MODE = "AnchorMode";
  private String anchorMode;

  public static final String JSON_PROPERTY_DATA_TYPE = "DataType";
  private String dataType;

  public static final String JSON_PROPERTY_MINIMUM_CHARACTER_COUNT = "MinimumCharacterCount";
  private Integer minimumCharacterCount;

  public static final String JSON_PROPERTY_ALLOW_NUMERIC_DIGITS = "AllowNumericDigits";
  private Boolean allowNumericDigits;


  public FormTableColumnDefinition columnID(String columnID) {
    
    this.columnID = columnID;
    return this;
  }

   /**
   * The identifier of the field; use this to identify which field is being referenced
   * @return columnID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the field; use this to identify which field is being referenced")
  @JsonProperty(JSON_PROPERTY_COLUMN_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColumnID() {
    return columnID;
  }


  public void setColumnID(String columnID) {
    this.columnID = columnID;
  }


  public FormTableColumnDefinition topAnchor(String topAnchor) {
    
    this.topAnchor = topAnchor;
    return this;
  }

   /**
   * Optional - the top anchor of the column heading
   * @return topAnchor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - the top anchor of the column heading")
  @JsonProperty(JSON_PROPERTY_TOP_ANCHOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTopAnchor() {
    return topAnchor;
  }


  public void setTopAnchor(String topAnchor) {
    this.topAnchor = topAnchor;
  }


  public FormTableColumnDefinition anchorMode(String anchorMode) {
    
    this.anchorMode = anchorMode;
    return this;
  }

   /**
   * Optional - the matching mode for the anchor.  Possible values are Complete (requires the entire anchor to match) and Partial (allows only part of the anchor to match).  Default is Partial.
   * @return anchorMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - the matching mode for the anchor.  Possible values are Complete (requires the entire anchor to match) and Partial (allows only part of the anchor to match).  Default is Partial.")
  @JsonProperty(JSON_PROPERTY_ANCHOR_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAnchorMode() {
    return anchorMode;
  }


  public void setAnchorMode(String anchorMode) {
    this.anchorMode = anchorMode;
  }


  public FormTableColumnDefinition dataType(String dataType) {
    
    this.dataType = dataType;
    return this;
  }

   /**
   * The data type of the field; possible values are INTEGER (Integer value), STRING (Arbitrary string value, spaces are permitted), DATE (Date in a structured format), DECIMAL (Decimal number), ALPHANUMERIC (Continuous alphanumeric string with no spaces), STRINGNOWHITESPACE (A string that contains no whitespace characters), SERIALNUMBER (A serial-number style string that contains letters and numbers, and certain symbols; must contain at least one number), ALPHAONLY (Alphabet characters only, no numbers or symbols or whitespace)
   * @return dataType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The data type of the field; possible values are INTEGER (Integer value), STRING (Arbitrary string value, spaces are permitted), DATE (Date in a structured format), DECIMAL (Decimal number), ALPHANUMERIC (Continuous alphanumeric string with no spaces), STRINGNOWHITESPACE (A string that contains no whitespace characters), SERIALNUMBER (A serial-number style string that contains letters and numbers, and certain symbols; must contain at least one number), ALPHAONLY (Alphabet characters only, no numbers or symbols or whitespace)")
  @JsonProperty(JSON_PROPERTY_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDataType() {
    return dataType;
  }


  public void setDataType(String dataType) {
    this.dataType = dataType;
  }


  public FormTableColumnDefinition minimumCharacterCount(Integer minimumCharacterCount) {
    
    this.minimumCharacterCount = minimumCharacterCount;
    return this;
  }

   /**
   * Optional - the target number of digits in the field; useful for fixed-length fields
   * @return minimumCharacterCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - the target number of digits in the field; useful for fixed-length fields")
  @JsonProperty(JSON_PROPERTY_MINIMUM_CHARACTER_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinimumCharacterCount() {
    return minimumCharacterCount;
  }


  public void setMinimumCharacterCount(Integer minimumCharacterCount) {
    this.minimumCharacterCount = minimumCharacterCount;
  }


  public FormTableColumnDefinition allowNumericDigits(Boolean allowNumericDigits) {
    
    this.allowNumericDigits = allowNumericDigits;
    return this;
  }

   /**
   * Optional - set to false to block values that contain numeric digits, set to true to allow numeric digits
   * @return allowNumericDigits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - set to false to block values that contain numeric digits, set to true to allow numeric digits")
  @JsonProperty(JSON_PROPERTY_ALLOW_NUMERIC_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowNumericDigits() {
    return allowNumericDigits;
  }


  public void setAllowNumericDigits(Boolean allowNumericDigits) {
    this.allowNumericDigits = allowNumericDigits;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormTableColumnDefinition formTableColumnDefinition = (FormTableColumnDefinition) o;
    return Objects.equals(this.columnID, formTableColumnDefinition.columnID) &&
        Objects.equals(this.topAnchor, formTableColumnDefinition.topAnchor) &&
        Objects.equals(this.anchorMode, formTableColumnDefinition.anchorMode) &&
        Objects.equals(this.dataType, formTableColumnDefinition.dataType) &&
        Objects.equals(this.minimumCharacterCount, formTableColumnDefinition.minimumCharacterCount) &&
        Objects.equals(this.allowNumericDigits, formTableColumnDefinition.allowNumericDigits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columnID, topAnchor, anchorMode, dataType, minimumCharacterCount, allowNumericDigits);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormTableColumnDefinition {\n");
    sb.append("    columnID: ").append(toIndentedString(columnID)).append("\n");
    sb.append("    topAnchor: ").append(toIndentedString(topAnchor)).append("\n");
    sb.append("    anchorMode: ").append(toIndentedString(anchorMode)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    minimumCharacterCount: ").append(toIndentedString(minimumCharacterCount)).append("\n");
    sb.append("    allowNumericDigits: ").append(toIndentedString(allowNumericDigits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

