/*
 * imageapi
 * Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Text instance to draw on an image
 */
@ApiModel(description = "Text instance to draw on an image")
@JsonPropertyOrder({
  DrawTextInstance.JSON_PROPERTY_TEXT,
  DrawTextInstance.JSON_PROPERTY_FONT_FAMILY_NAME,
  DrawTextInstance.JSON_PROPERTY_FONT_SIZE,
  DrawTextInstance.JSON_PROPERTY_COLOR,
  DrawTextInstance.JSON_PROPERTY_X,
  DrawTextInstance.JSON_PROPERTY_Y,
  DrawTextInstance.JSON_PROPERTY_WIDTH,
  DrawTextInstance.JSON_PROPERTY_HEIGHT
})
@JsonTypeName("DrawTextInstance")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:16.765-08:00[America/Los_Angeles]")
public class DrawTextInstance {
  public static final String JSON_PROPERTY_TEXT = "Text";
  private String text;

  public static final String JSON_PROPERTY_FONT_FAMILY_NAME = "FontFamilyName";
  private String fontFamilyName;

  public static final String JSON_PROPERTY_FONT_SIZE = "FontSize";
  private Double fontSize;

  public static final String JSON_PROPERTY_COLOR = "Color";
  private String color;

  public static final String JSON_PROPERTY_X = "X";
  private Double X;

  public static final String JSON_PROPERTY_Y = "Y";
  private Double Y;

  public static final String JSON_PROPERTY_WIDTH = "Width";
  private Double width;

  public static final String JSON_PROPERTY_HEIGHT = "Height";
  private Double height;


  public DrawTextInstance text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Text string to draw
   * @return text
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Text string to draw")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  public void setText(String text) {
    this.text = text;
  }


  public DrawTextInstance fontFamilyName(String fontFamilyName) {
    
    this.fontFamilyName = fontFamilyName;
    return this;
  }

   /**
   * Font Family to use.  Leave blank to default to \&quot;Arial\&quot;.  Supported fonts including Arial, Calibri, Cambria, Candara, Consolas, Constantia, Corbel, Courier New, Courier Regular, Georgia, Impact Regular, Lucida, Modern Regular, Tahoma, Times New Roman, Verdana
   * @return fontFamilyName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Font Family to use.  Leave blank to default to \"Arial\".  Supported fonts including Arial, Calibri, Cambria, Candara, Consolas, Constantia, Corbel, Courier New, Courier Regular, Georgia, Impact Regular, Lucida, Modern Regular, Tahoma, Times New Roman, Verdana")
  @JsonProperty(JSON_PROPERTY_FONT_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontFamilyName() {
    return fontFamilyName;
  }


  public void setFontFamilyName(String fontFamilyName) {
    this.fontFamilyName = fontFamilyName;
  }


  public DrawTextInstance fontSize(Double fontSize) {
    
    this.fontSize = fontSize;
    return this;
  }

   /**
   * Font size to use.
   * @return fontSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Font size to use.")
  @JsonProperty(JSON_PROPERTY_FONT_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFontSize() {
    return fontSize;
  }


  public void setFontSize(Double fontSize) {
    this.fontSize = fontSize;
  }


  public DrawTextInstance color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Color to use - can be a hex value (with #) or HTML common color name
   * @return color
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Color to use - can be a hex value (with #) or HTML common color name")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  public void setColor(String color) {
    this.color = color;
  }


  public DrawTextInstance X(Double X) {
    
    this.X = X;
    return this;
  }

   /**
   * Pixel location of the left edge of the text location
   * @return X
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Pixel location of the left edge of the text location")
  @JsonProperty(JSON_PROPERTY_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getX() {
    return X;
  }


  public void setX(Double X) {
    this.X = X;
  }


  public DrawTextInstance Y(Double Y) {
    
    this.Y = Y;
    return this;
  }

   /**
   * Pixel location of the top edge of the text location
   * @return Y
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Pixel location of the top edge of the text location")
  @JsonProperty(JSON_PROPERTY_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getY() {
    return Y;
  }


  public void setY(Double Y) {
    this.Y = Y;
  }


  public DrawTextInstance width(Double width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width in pixels of the text box to draw the text in; text will wrap inside this box
   * @return width
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Width in pixels of the text box to draw the text in; text will wrap inside this box")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getWidth() {
    return width;
  }


  public void setWidth(Double width) {
    this.width = width;
  }


  public DrawTextInstance height(Double height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height in pixels of the text box to draw the text in; text will wrap inside this box
   * @return height
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Height in pixels of the text box to draw the text in; text will wrap inside this box")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getHeight() {
    return height;
  }


  public void setHeight(Double height) {
    this.height = height;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DrawTextInstance drawTextInstance = (DrawTextInstance) o;
    return Objects.equals(this.text, drawTextInstance.text) &&
        Objects.equals(this.fontFamilyName, drawTextInstance.fontFamilyName) &&
        Objects.equals(this.fontSize, drawTextInstance.fontSize) &&
        Objects.equals(this.color, drawTextInstance.color) &&
        Objects.equals(this.X, drawTextInstance.X) &&
        Objects.equals(this.Y, drawTextInstance.Y) &&
        Objects.equals(this.width, drawTextInstance.width) &&
        Objects.equals(this.height, drawTextInstance.height);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, fontFamilyName, fontSize, color, X, Y, width, height);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DrawTextInstance {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    fontFamilyName: ").append(toIndentedString(fontFamilyName)).append("\n");
    sb.append("    fontSize: ").append(toIndentedString(fontSize)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    X: ").append(toIndentedString(X)).append("\n");
    sb.append("    Y: ").append(toIndentedString(Y)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

