/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v503.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.definition.DimensionDefinition;
import com.nukkitx.protocol.bedrock.packet.DimensionDataPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class DimensionDataSerializer_v503
implements BedrockPacketSerializer<DimensionDataPacket> {
    public static final DimensionDataSerializer_v503 INSTANCE = new DimensionDataSerializer_v503();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, DimensionDataPacket packet) {
        helper.writeArray(buffer, (Collection)packet.getDefinitions(), this::writeDefinition);
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, DimensionDataPacket packet) {
        helper.readArray(buffer, (Collection)packet.getDefinitions(), this::readDefinition);
    }

    protected void writeDefinition(ByteBuf buffer, BedrockPacketHelper helper, DimensionDefinition definition) {
        helper.writeString(buffer, definition.getId());
        VarInts.writeInt((ByteBuf)buffer, (int)definition.getMaximumHeight());
        VarInts.writeInt((ByteBuf)buffer, (int)definition.getMinimumHeight());
        VarInts.writeInt((ByteBuf)buffer, (int)definition.getGeneratorType());
    }

    protected DimensionDefinition readDefinition(ByteBuf buffer, BedrockPacketHelper helper) {
        String id = helper.readString(buffer);
        int maximumHeight = VarInts.readInt((ByteBuf)buffer);
        int minimumHeight = VarInts.readInt((ByteBuf)buffer);
        int generatorType = VarInts.readInt((ByteBuf)buffer);
        return new DimensionDefinition(id, maximumHeight, minimumHeight, generatorType);
    }

    protected DimensionDataSerializer_v503() {
    }
}

