/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v419.serializer;

import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.AuthoritativeMovementMode;
import com.nukkitx.protocol.bedrock.data.BlockPropertyData;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.SpawnBiomeType;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class StartGameSerializer_v419
implements BedrockPacketSerializer<StartGamePacket> {
    public static final StartGameSerializer_v419 INSTANCE = new StartGameSerializer_v419();
    protected static final PlayerPermission[] PLAYER_PERMISSIONS = PlayerPermission.values();
    protected static final AuthoritativeMovementMode[] MOVEMENT_MODES = AuthoritativeMovementMode.values();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlayerGameType().ordinal());
        helper.writeVector3f(buffer, packet.getPlayerPosition());
        helper.writeVector2f(buffer, packet.getRotation());
        this.writeLevelSettings(buffer, helper, packet);
        helper.writeString(buffer, packet.getLevelId());
        helper.writeString(buffer, packet.getLevelName());
        helper.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getAuthoritativeMovementMode().ordinal());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEnchantmentSeed());
        helper.writeArray(buffer, (Collection)packet.getBlockProperties(), (buf, packetHelper, block) -> {
            packetHelper.writeString(buf, block.getName());
            packetHelper.writeTag(buf, (Object)block.getProperties());
        });
        helper.writeArray(buffer, (Collection)packet.getItemEntries(), (buf, packetHelper, entry) -> {
            packetHelper.writeString(buf, entry.getIdentifier());
            buf.writeShortLE((int)entry.getId());
            buf.writeBoolean(entry.isComponentBased());
        });
        helper.writeString(buffer, packet.getMultiplayerCorrelationId());
        buffer.writeBoolean(packet.isInventoriesServerAuthoritative());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet, BedrockSession session) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPlayerGameType(GameType.from((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlayerPosition(helper.readVector3f(buffer));
        packet.setRotation(helper.readVector2f(buffer));
        this.readLevelSettings(buffer, helper, packet);
        packet.setLevelId(helper.readString(buffer));
        packet.setLevelName(helper.readString(buffer));
        packet.setPremiumWorldTemplateId(helper.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setAuthoritativeMovementMode(MOVEMENT_MODES[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt((ByteBuf)buffer));
        helper.readArray(buffer, (Collection)packet.getBlockProperties(), (buf, packetHelper) -> {
            String name = packetHelper.readString(buf);
            NbtMap properties = (NbtMap)packetHelper.readTag(buf);
            return new BlockPropertyData(name, properties);
        });
        helper.readArray(buffer, (Collection)packet.getItemEntries(), session, (buf, packetHelper, aSession) -> {
            String identifier = packetHelper.readString(buf);
            short id = buf.readShortLE();
            boolean componentBased = buf.readBoolean();
            if (identifier.equals(packetHelper.getBlockingItemIdentifier())) {
                aSession.getHardcodedBlockingId().set(id);
            }
            return new StartGamePacket.ItemEntry(identifier, id, componentBased);
        });
        packet.setMultiplayerCorrelationId(helper.readString(buffer));
        packet.setInventoriesServerAuthoritative(buffer.readBoolean());
    }

    protected void writeLevelSettings(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getSeed());
        buffer.writeShortLE(packet.getSpawnBiomeType().ordinal());
        helper.writeString(buffer, packet.getCustomBiomeName());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getGeneratorId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getLevelGameType().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDifficulty());
        helper.writeBlockPosition(buffer, packet.getDefaultSpawn());
        buffer.writeBoolean(packet.isAchievementsDisabled());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDayCycleStopTime());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEduEditionOffers());
        buffer.writeBoolean(packet.isEduFeaturesEnabled());
        helper.writeString(buffer, packet.getEducationProductionId());
        buffer.writeFloatLE(packet.getRainLevel());
        buffer.writeFloatLE(packet.getLightningLevel());
        buffer.writeBoolean(packet.isPlatformLockedContentConfirmed());
        buffer.writeBoolean(packet.isMultiplayerGame());
        buffer.writeBoolean(packet.isBroadcastingToLan());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getXblBroadcastMode().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlatformBroadcastMode().ordinal());
        buffer.writeBoolean(packet.isCommandsEnabled());
        buffer.writeBoolean(packet.isTexturePacksRequired());
        helper.writeArray(buffer, (Collection)packet.getGamerules(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeGameRule(arg_0, arg_1));
        helper.writeExperiments(buffer, packet.getExperiments());
        buffer.writeBoolean(packet.isExperimentsPreviouslyToggled());
        buffer.writeBoolean(packet.isBonusChestEnabled());
        buffer.writeBoolean(packet.isStartingWithMap());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDefaultPlayerPermission().ordinal());
        buffer.writeIntLE(packet.getServerChunkTickRange());
        buffer.writeBoolean(packet.isBehaviorPackLocked());
        buffer.writeBoolean(packet.isResourcePackLocked());
        buffer.writeBoolean(packet.isFromLockedWorldTemplate());
        buffer.writeBoolean(packet.isUsingMsaGamertagsOnly());
        buffer.writeBoolean(packet.isFromWorldTemplate());
        buffer.writeBoolean(packet.isWorldTemplateOptionLocked());
        buffer.writeBoolean(packet.isOnlySpawningV1Villagers());
        helper.writeString(buffer, packet.getVanillaVersion());
        buffer.writeIntLE(packet.getLimitedWorldWidth());
        buffer.writeIntLE(packet.getLimitedWorldHeight());
        buffer.writeBoolean(packet.isNetherType());
        buffer.writeBoolean(packet.isForceExperimentalGameplay());
        if (packet.isForceExperimentalGameplay()) {
            buffer.writeBoolean(true);
        }
    }

    protected void readLevelSettings(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        packet.setSeed(VarInts.readInt((ByteBuf)buffer));
        packet.setSpawnBiomeType(SpawnBiomeType.byId((int)buffer.readShortLE()));
        packet.setCustomBiomeName(helper.readString(buffer));
        packet.setDimensionId(VarInts.readInt((ByteBuf)buffer));
        packet.setGeneratorId(VarInts.readInt((ByteBuf)buffer));
        packet.setLevelGameType(GameType.from((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setDifficulty(VarInts.readInt((ByteBuf)buffer));
        packet.setDefaultSpawn(helper.readBlockPosition(buffer));
        packet.setAchievementsDisabled(buffer.readBoolean());
        packet.setDayCycleStopTime(VarInts.readInt((ByteBuf)buffer));
        packet.setEduEditionOffers(VarInts.readInt((ByteBuf)buffer));
        packet.setEduFeaturesEnabled(buffer.readBoolean());
        packet.setEducationProductionId(helper.readString(buffer));
        packet.setRainLevel(buffer.readFloatLE());
        packet.setLightningLevel(buffer.readFloatLE());
        packet.setPlatformLockedContentConfirmed(buffer.readBoolean());
        packet.setMultiplayerGame(buffer.readBoolean());
        packet.setBroadcastingToLan(buffer.readBoolean());
        packet.setXblBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlatformBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setCommandsEnabled(buffer.readBoolean());
        packet.setTexturePacksRequired(buffer.readBoolean());
        helper.readArray(buffer, (Collection)packet.getGamerules(), arg_0 -> ((BedrockPacketHelper)helper).readGameRule(arg_0));
        helper.readExperiments(buffer, packet.getExperiments());
        packet.setExperimentsPreviouslyToggled(buffer.readBoolean());
        packet.setBonusChestEnabled(buffer.readBoolean());
        packet.setStartingWithMap(buffer.readBoolean());
        packet.setDefaultPlayerPermission(PLAYER_PERMISSIONS[VarInts.readInt((ByteBuf)buffer)]);
        packet.setServerChunkTickRange(buffer.readIntLE());
        packet.setBehaviorPackLocked(buffer.readBoolean());
        packet.setResourcePackLocked(buffer.readBoolean());
        packet.setFromLockedWorldTemplate(buffer.readBoolean());
        packet.setUsingMsaGamertagsOnly(buffer.readBoolean());
        packet.setFromWorldTemplate(buffer.readBoolean());
        packet.setWorldTemplateOptionLocked(buffer.readBoolean());
        packet.setOnlySpawningV1Villagers(buffer.readBoolean());
        packet.setVanillaVersion(helper.readString(buffer));
        packet.setLimitedWorldWidth(buffer.readIntLE());
        packet.setLimitedWorldHeight(buffer.readIntLE());
        packet.setNetherType(buffer.readBoolean());
        if (buffer.readBoolean()) {
            packet.setForceExperimentalGameplay(buffer.readBoolean());
        }
    }

    protected StartGameSerializer_v419() {
    }
}

