/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v419.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.packet.ItemStackResponsePacket;
import com.nukkitx.protocol.bedrock.v407.serializer.ItemStackResponseSerializer_v407;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ItemStackResponseSerializer_v419
extends ItemStackResponseSerializer_v407 {
    public static final ItemStackResponseSerializer_v419 INSTANCE = new ItemStackResponseSerializer_v419();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, (Collection)packet.getEntries(), (buf, response) -> {
            buf.writeByte(response.getResult().ordinal());
            VarInts.writeInt((ByteBuf)buffer, (int)response.getRequestId());
            if (response.getResult() != ItemStackResponsePacket.ResponseStatus.OK) {
                return;
            }
            helper.writeArray(buf, (Collection)response.getContainers(), (buf2, containerEntry) -> {
                buf2.writeByte(containerEntry.getContainer().ordinal());
                helper.writeArray(buf2, (Collection)containerEntry.getItems(), (arg_0, arg_1, arg_2) -> ((ItemStackResponseSerializer_v419)this).writeItemEntry(arg_0, arg_1, arg_2));
            });
        });
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        List entries = packet.getEntries();
        helper.readArray(buffer, (Collection)entries, buf -> {
            ItemStackResponsePacket.ResponseStatus result = ItemStackResponsePacket.ResponseStatus.values()[buf.readByte()];
            int requestId = VarInts.readInt((ByteBuf)buf);
            if (result != ItemStackResponsePacket.ResponseStatus.OK) {
                return new ItemStackResponsePacket.Response(result, requestId, Collections.emptyList());
            }
            ArrayList containerEntries = new ArrayList();
            helper.readArray(buf, containerEntries, buf2 -> {
                ContainerSlotType container = ContainerSlotType.values()[buf2.readByte()];
                ArrayList itemEntries = new ArrayList();
                helper.readArray(buf2, itemEntries, byteBuf -> this.readItemEntry((ByteBuf)buf2, helper));
                return new ItemStackResponsePacket.ContainerEntry(container, itemEntries);
            });
            return new ItemStackResponsePacket.Response(result, requestId, containerEntries);
        });
    }
}

